/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;

public class KieContainerInstance {
    private KieContainerResource resource;
    private InternalKieContainer kieContainer;
    private InternalKieScanner scanner;
    private Map<MarshallingFormat, Marshaller> marshallers;

    public KieContainerInstance(String containerId, KieContainerStatus status) {
        this(containerId, status, null);
    }

    public KieContainerInstance(String containerId, KieContainerStatus status, InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.resource = new KieContainerResource(containerId, null, status);
        this.marshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();
        this.updateReleaseId();
    }

    public String getContainerId() {
        return this.resource.getContainerId();
    }

    public void setContainerId(String containerId) {
        this.resource.setContainerId(containerId);
    }

    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.updateReleaseId();
    }

    public KieContainerStatus getStatus() {
        return this.resource.getStatus();
    }

    public void setStatus(KieContainerStatus status) {
        this.resource.setStatus(status);
    }

    public KieContainerResource getResource() {
        this.updateReleaseId();
        return this.resource;
    }

    public void setResource(KieContainerResource resource) {
        this.resource = resource;
    }

    public void setScanner(InternalKieScanner scanner) {
        this.scanner = scanner;
    }

    public InternalKieScanner getScanner() {
        return this.scanner;
    }

    private void updateReleaseId() {
        if (this.kieContainer != null) {
            this.resource.setReleaseId(new ReleaseId(this.kieContainer.getContainerReleaseId()));
            this.resource.setResolvedReleaseId(new ReleaseId(this.kieContainer.getReleaseId()));
        }
        this.disposeMarshallers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Marshaller getMarshaller(MarshallingFormat format) {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            Marshaller marshaller = this.marshallers.get(format);
            if (marshaller == null) {
                marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)format, (ClassLoader)this.kieContainer.getClassLoader());
                this.marshallers.put(format, marshaller);
            }
            return marshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeMarshallers() {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            for (Marshaller marshaller : this.marshallers.values()) {
                marshaller.dispose();
            }
            this.marshallers.clear();
        }
    }

    public String toString() {
        return this.resource.toString();
    }
}

