/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.spring.boot.autoconfiguration.audit.replication;

import com.thoughtworks.xstream.XStream;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAuditDataReplicationJMSConsumer {
    private static Logger logger = LoggerFactory.getLogger(AbstractAuditDataReplicationJMSConsumer.class);
    @Autowired
    private XStream xstream;
    private EntityManagerFactory emf;
    private AtomicLong processedMessages = new AtomicLong();

    public Long get() {
        return this.processedMessages.get();
    }

    public void reset() {
        this.processedMessages.set(0L);
    }

    public AbstractAuditDataReplicationJMSConsumer(EntityManagerFactory emf) {
        this.emf = emf;
    }

    protected void processMessage(Object message) {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            try (EntityManager em = this.emf.createEntityManager();){
                String messageContent = textMessage.getText();
                Integer eventType = textMessage.getIntProperty("EventType");
                logger.debug("Message type {} received:\n{}", (Object)eventType, (Object)messageContent);
                Object event = this.xstream.fromXML(messageContent);
                em.merge(event);
                this.processedMessages.incrementAndGet();
            }
        }
    }
}

