/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.spring.boot.autoconfiguration.audit.replication;

import java.util.List;
import java.util.Map;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.server.spring.boot.autoconfiguration.audit.replication.JMSSender;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditDataReplicationTaskLifeCycleEventListenerProducer
extends DefaultTaskEventListener {
    @Autowired
    private JMSSender jmsSender;

    private void sendMessage(TaskEvent event, int type) {
        Object msg = event.getMetadata().get("TASK_EVENT");
        if (msg != null) {
            this.jmsSender.sendMessage(msg, type);
            event.getMetadata().remove("TASK_EVENT");
        }
        if ((msg = event.getMetadata().get("TASK_AUDIT_EVENT")) != null) {
            this.jmsSender.sendMessage(msg, type);
            event.getMetadata().remove("TASK_AUDIT_EVENT");
        }
        if ((msg = event.getMetadata().get("TASK_VAR_EVENT")) != null) {
            List variables = (List)msg;
            variables.forEach(e -> this.jmsSender.sendMessage(e, type));
            event.getMetadata().remove("TASK_VAR_EVENT");
        }
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        this.sendMessage(event, 202);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        this.sendMessage(event, 203);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        this.sendMessage(event, 204);
    }

    public void afterTaskStartedEvent(TaskEvent event) {
        this.sendMessage(event, 201);
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        this.sendMessage(event, 205);
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        this.sendMessage(event, 206);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        this.sendMessage(event, 207);
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        this.sendMessage(event, 209);
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        this.sendMessage(event, 210);
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
        this.sendMessage(event, 211);
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        this.sendMessage(event, 211);
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        this.sendMessage(event, 212);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        this.sendMessage(event, 213);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        this.sendMessage(event, 214);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        this.sendMessage(event, 215);
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
        this.sendMessage(event, 216);
    }

    public void afterTaskOutputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        this.sendMessage(event, 219);
    }

    public void afterTaskInputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        this.sendMessage(event, 210);
    }

    public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.sendMessage(event, 218);
    }

    public void afterTaskAssignmentsRemovedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.sendMessage(event, 218);
    }
}

