/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.appformer.maven.support.DependencyFilter;
import org.drools.core.impl.InternalKieContainer;
import org.kie.internal.identity.IdentityProvider;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.InmutableContainerStartupStrategy;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.memory.InMemoryKieServerStateRepository;
import org.kie.server.springboot.InmutableSpringBootKieContainerInstanceImpl;
import org.kie.server.springboot.SpringBootKieServerImpl;

public class ImmutableSpringBootKieServerImpl
extends SpringBootKieServerImpl {
    private List<KieContainerResource> containers;

    public ImmutableSpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider) {
        this(extensions, identityProvider, Collections.emptyList());
    }

    public ImmutableSpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider, List<KieContainerResource> containers) {
        super(extensions, identityProvider, (KieServerStateRepository)new InMemoryKieServerStateRepository());
        this.containers = containers;
    }

    protected KieModuleMetaData buildKieModuleMetadata(org.kie.api.builder.ReleaseId releaseId) {
        return KieModuleMetaData.Factory.newInJarKieModuleMetaData((org.kie.api.builder.ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
    }

    protected InternalKieContainer createInternalKieContainer(String containerId, ReleaseId releaseId, KieModuleMetaData metaData) {
        return (InternalKieContainer)this.ks.newKieClasspathContainer(containerId, metaData.getClassLoader(), (org.kie.api.builder.ReleaseId)releaseId);
    }

    protected KieContainerInstanceImpl createContainerInstanceImpl(String containerId, ReleaseId releaseId) {
        return new InmutableSpringBootKieContainerInstanceImpl(containerId, KieContainerStatus.CREATING, null, releaseId, this);
    }

    public KieServerController getController() {
        return new SpringBootKieServerController();
    }

    @Override
    public void init() {
        this.init((StartupStrategy)new InmutableContainerStartupStrategy());
    }

    private class SpringBootKieServerController
    implements KieServerController {
        private SpringBootKieServerController() {
        }

        public void disconnect(KieServerInfo serverInfo) {
        }

        public KieServerSetup connect(KieServerInfo serverInfo) {
            KieServerSetup serverSetup = new KieServerSetup();
            serverSetup.setContainers(new HashSet(ImmutableSpringBootKieServerImpl.this.containers));
            return serverSetup;
        }
    }
}

