/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.Person;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringBasicsTest {
    static ClassPathXmlApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/kie-beans.xml");
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testReleaseId() throws Exception {
        ReleaseId releaseId = (ReleaseId)context.getBean("dummyReleaseId");
        Assert.assertNotNull((Object)releaseId);
    }

    @Test
    public void testKieSessionRef() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession1");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession9");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSessionDefaultType() throws Exception {
        Object obj = context.getBean("ksession99");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof KieSession));
    }

    @Test
    public void testKSessionExecution() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("ksession1");
        Assert.assertNotNull((Object)ksession);
        Person person = new Person("HAL", 42);
        person.setHappy(false);
        ksession.execute((Object)person);
        Assert.assertTrue((boolean)person.isHappy());
    }

    @AfterClass
    public static void tearDown() {
        context.destroy();
    }
}

