/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.Person;
import org.kie.spring.mocks.MockAgendaEventListener;
import org.kie.spring.mocks.MockProcessEventListener;
import org.kie.spring.mocks.MockWorkingMemoryEventListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringListenersTest {
    static ClassPathXmlApplicationContext context = null;
    List<Person> list = new ArrayList<Person>();
    static int counterFromListener = 0;

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/listeners.xml");
    }

    @Before
    public void clearGlobalList() {
        this.list.clear();
        counterFromListener = 0;
    }

    public static void incrementValueFromListener() {
        ++counterFromListener;
    }

    @Test
    public void testStatefulAgendaEventListener() throws Exception {
        KieSession kSession = (KieSession)context.getBean("ksession2");
        Assert.assertTrue((kSession.getAgendaEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockAgendaEventListenerFound = false;
        for (AgendaEventListener listener : kSession.getAgendaEventListeners()) {
            if (!(listener instanceof MockAgendaEventListener)) continue;
            mockAgendaEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockAgendaEventListenerFound);
    }

    @Test
    public void testStatefulProcessEventListener() throws Exception {
        KieSession kSession = (KieSession)context.getBean("ksession2");
        Assert.assertTrue((kSession.getProcessEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockProcessEventListenerFound = false;
        for (ProcessEventListener listener : kSession.getProcessEventListeners()) {
            if (!(listener instanceof MockProcessEventListener)) continue;
            mockProcessEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockProcessEventListenerFound);
    }

    @Test
    public void testStatefulWMEventListener() throws Exception {
        KieSession kSession = (KieSession)context.getBean("ksession2");
        Assert.assertTrue((kSession.getWorkingMemoryEventListeners().size() > 0 ? 1 : 0) != 0);
        boolean mockWMEventListenerFound = false;
        for (WorkingMemoryEventListener listener : kSession.getWorkingMemoryEventListeners()) {
            if (!(listener instanceof MockWorkingMemoryEventListener)) continue;
            mockWMEventListenerFound = true;
            break;
        }
        Assert.assertTrue((boolean)mockWMEventListenerFound);
        kSession.insert((Object)new Person());
        kSession.fireAllRules();
        Assert.assertTrue((counterFromListener > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStatelessWithGroupedListeners() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithGroupedListeners");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getWorkingMemoryEventListeners().size());
        StatelessKieSession2.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }
}

