/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.KieObjectsResolver;
import org.kie.spring.factorybeans.LoggerAdaptor;
import org.kie.spring.factorybeans.helper.KSessionFactoryBeanHelper;
import org.kie.spring.factorybeans.helper.StatefulKSessionFactoryBeanHelper;
import org.kie.spring.factorybeans.helper.StatelessKSessionFactoryBeanHelper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.ManagedList;

public class KSessionFactoryBean
implements FactoryBean,
InitializingBean {
    protected List<AgendaEventListener> agendaEventListeners;
    protected List<ProcessEventListener> processEventListeners;
    protected List<WorkingMemoryEventListener> workingMemoryEventListeners;
    protected List<Object> groupedListeners = new ArrayList<Object>();
    protected String id;
    protected String type;
    protected String kbaseName;
    private KieSessionConfiguration conf;
    private List<Command<?>> batch;
    private ReleaseId releaseId;
    protected ManagedList<LoggerAdaptor> loggerAdaptors = new ManagedList();
    protected KSessionFactoryBeanHelper helper;
    protected boolean refLookup;
    private StatefulKSessionFactoryBeanHelper.JpaConfiguration jpaConfiguration;

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public boolean getRefLookup() {
        return this.refLookup;
    }

    public void setRefLookup(boolean refLookup) {
        this.refLookup = refLookup;
    }

    public String getKbaseName() {
        return this.kbaseName;
    }

    public void setKbaseName(String kbase) {
        this.kbaseName = kbase;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public KieSessionConfiguration getConf() {
        return this.conf;
    }

    public void setConf(KieSessionConfiguration conf) {
        this.conf = conf;
    }

    public List<Command<?>> getBatch() {
        return this.batch;
    }

    public void setBatch(List<Command<?>> commands) {
        this.batch = commands;
    }

    public KSessionFactoryBean() {
        this.agendaEventListeners = new ArrayList<AgendaEventListener>();
        this.processEventListeners = new ArrayList<ProcessEventListener>();
        this.workingMemoryEventListeners = new ArrayList<WorkingMemoryEventListener>();
    }

    public Object getObject() throws Exception {
        return this.helper.internalGetObject();
    }

    public Class<?> getObjectType() {
        return this.internalGetObjectType();
    }

    public boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        Object obj = null;
        if (this.refLookup) {
            obj = kieObjectsResolver.resolveKSession(this.id, this.releaseId);
            if (obj instanceof StatelessKieSession) {
                this.helper = new StatelessKSessionFactoryBeanHelper(this, (StatelessKieSession)obj);
            } else if (obj instanceof KieSession) {
                this.helper = new StatefulKSessionFactoryBeanHelper(this, (KieSession)obj);
            }
        } else if ("stateless".equalsIgnoreCase(this.type)) {
            obj = kieObjectsResolver.newStatelessSession(this.kbaseName, this.releaseId, this.conf);
            this.helper = new StatelessKSessionFactoryBeanHelper(this, (StatelessKieSession)obj);
        } else {
            obj = kieObjectsResolver.newStatefulSession(this.kbaseName, this.releaseId, this.conf);
            this.helper = new StatefulKSessionFactoryBeanHelper(this, (KieSession)obj);
        }
        this.helper.internalAfterPropertiesSet();
        this.attachLoggers((KieRuntimeEventManager)obj);
        this.attachListeners((KieRuntimeEventManager)obj);
    }

    public StatefulKSessionFactoryBeanHelper.JpaConfiguration getJpaConfiguration() {
        return this.jpaConfiguration;
    }

    public void setJpaConfiguration(StatefulKSessionFactoryBeanHelper.JpaConfiguration jpaConfiguration) {
        this.jpaConfiguration = jpaConfiguration;
    }

    protected Class<? extends KieRuntime> internalGetObjectType() {
        return KieRuntime.class;
    }

    public void setEventListenersFromGroup(List<Object> eventListenerList) {
        for (Object eventListener : eventListenerList) {
            if (eventListener instanceof AgendaEventListener) {
                this.agendaEventListeners.add((AgendaEventListener)eventListener);
            }
            if (eventListener instanceof WorkingMemoryEventListener) {
                this.workingMemoryEventListeners.add((WorkingMemoryEventListener)eventListener);
            }
            if (!(eventListener instanceof ProcessEventListener)) continue;
            this.processEventListeners.add((ProcessEventListener)eventListener);
        }
        this.groupedListeners.addAll(eventListenerList);
    }

    public void setEventListeners(Map<String, List> eventListenerMap) {
        for (Map.Entry<String, List> entry : eventListenerMap.entrySet()) {
            String key = entry.getKey();
            List eventListenerList = entry.getValue();
            if ("agenda-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof AgendaEventListener) {
                        this.agendaEventListeners.add((AgendaEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The agendaEventListener (" + eventListener.getClass() + ") is not an instance of " + AgendaEventListener.class);
                }
                continue;
            }
            if ("working-memory-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof WorkingMemoryEventListener) {
                        this.workingMemoryEventListeners.add((WorkingMemoryEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The workingMemoryEventListener (" + eventListener.getClass() + ") is not an instance of " + WorkingMemoryEventListener.class);
                }
                continue;
            }
            if (!"process-event-listener".equalsIgnoreCase(key)) continue;
            for (Object eventListener : eventListenerList) {
                if (eventListener instanceof ProcessEventListener) {
                    this.processEventListeners.add((ProcessEventListener)eventListener);
                    continue;
                }
                throw new IllegalArgumentException("The processEventListener (" + eventListener.getClass() + ") is not an instance of " + ProcessEventListener.class);
            }
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventListeners;
    }

    public void setAgendaEventListeners(List<AgendaEventListener> agendaEventListeners) {
        this.agendaEventListeners = agendaEventListeners;
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventListeners;
    }

    public void setProcessEventListeners(List<ProcessEventListener> processEventListeners) {
        this.processEventListeners = processEventListeners;
    }

    public List<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return this.workingMemoryEventListeners;
    }

    public void setWorkingMemoryEventListeners(List<WorkingMemoryEventListener> workingMemoryEventListeners) {
        this.workingMemoryEventListeners = workingMemoryEventListeners;
    }

    public List<LoggerAdaptor> getKnowledgeRuntimeLoggers() {
        return this.loggerAdaptors;
    }

    public void setKnowledgeRuntimeLoggers(List<LoggerAdaptor> loggers) {
        this.loggerAdaptors.addAll(loggers);
    }

    public void attachListeners(KieRuntimeEventManager kieRuntimeEventManager) {
        for (AgendaEventListener agendaEventListener : this.getAgendaEventListeners()) {
            kieRuntimeEventManager.addEventListener(agendaEventListener);
        }
        for (ProcessEventListener processEventListener : this.getProcessEventListeners()) {
            kieRuntimeEventManager.addEventListener(processEventListener);
        }
        for (WorkingMemoryEventListener workingMemoryEventListener : this.getWorkingMemoryEventListeners()) {
            kieRuntimeEventManager.addEventListener(workingMemoryEventListener);
        }
    }

    public void attachLoggers(KieRuntimeEventManager ksession) {
        if (this.loggerAdaptors != null && this.loggerAdaptors.size() > 0) {
            KieServices ks = KieServices.Factory.get();
            KieLoggers loggers = ks.getLoggers();
            for (LoggerAdaptor adaptor : this.loggerAdaptors) {
                switch (adaptor.getLoggerType()) {
                    case LOGGER_TYPE_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newFileLogger(ksession, adaptor.getFile());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_THREADED_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newThreadedFileLogger(ksession, adaptor.getFile(), adaptor.getInterval());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_CONSOLE: {
                        KieRuntimeLogger runtimeLogger = loggers.newConsoleLogger(ksession);
                        adaptor.setRuntimeLogger(runtimeLogger);
                    }
                }
            }
        }
    }
}

