/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.net.URL;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.InternalKieSpringUtils;
import org.springframework.context.ApplicationContext;

public class InternalKieSpringUtilsTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("sample-group", "test-spring", "0001");
        URL configFileURL = InternalKieSpringUtilsTest.class.getResource("/org/kie/spring/beans-internal.xml");
        context = InternalKieSpringUtils.getSpringContext((ReleaseId)releaseId, (URL)configFileURL);
    }

    @Test
    public void testContextNotNull() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKBase() throws Exception {
        Object object = context.getBean("drl_kiesample3");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof KieBase));
    }

    @Test
    public void testKieSession() throws Exception {
        Object object = context.getBean("ksession2");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof KieSession));
    }

    @Test
    public void testKieStatelessSession() throws Exception {
        Object object = context.getBean("ksession1");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof StatelessKieSession));
    }

    @AfterClass
    public static void tearDown() {
    }
}

