/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.net.URL;
import java.util.ArrayList;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.spring.InternalKieSpringUtils;
import org.kie.spring.beans.Person;
import org.kie.spring.tests.InternalKieSpringUtilsTest;
import org.springframework.context.ApplicationContext;

public class KieSpringCommandsTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("kie-spring-commands", "test-spring", "0001");
        URL configFileURL = InternalKieSpringUtilsTest.class.getResource("/org/kie/spring/beans-commands.xml");
        context = InternalKieSpringUtils.getSpringContext((ReleaseId)releaseId, (URL)configFileURL);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("drl_kiesample3");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testInsertObject() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksession2");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertFalse((boolean)((Person)object).isHappy());
        }
        ksession.fireAllRules();
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testInsertObjectAndFireAll() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testSetGlobals() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        Person p1 = (Person)ksession.getObjects().toArray()[0];
        Assert.assertNotNull((Object)p1);
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
        Object list = ksession.getGlobal("persons");
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)(list instanceof ArrayList));
        Assert.assertEquals((long)1L, (long)((ArrayList)list).size());
        Person p = (Person)((ArrayList)list).get(0);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)p, (Object)p1);
    }

    @AfterClass
    public static void tearDown() {
    }
}

