/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.net.URL;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.spring.InternalKieSpringUtils;
import org.kie.spring.mocks.MockObjectMarshallingStrategy;
import org.kie.spring.tests.InternalKieSpringUtilsTest;
import org.springframework.context.ApplicationContext;

public class KieSpringEnvironmentTest {
    static ApplicationContext context = null;
    private static Server h2Server;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @BeforeClass
    public static void runBeforeClass() {
        ReleaseIdImpl releaseId = new ReleaseIdImpl("kie-spring-commands", "test-spring", "0001");
        URL configFileURL = InternalKieSpringUtilsTest.class.getResource("/org/kie/spring/environment.xml");
        context = InternalKieSpringUtils.getSpringContext((ReleaseId)releaseId, (URL)configFileURL);
    }

    @Test
    public void testCtxNotNull() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testEnvRef() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.transaction.TransactionManager"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        Assert.assertNotNull((Object)environment.get("org.kie.Globals"));
        Assert.assertNotNull((Object)environment.get("org.kie.build.DateFormats"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.time.Calendars"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies"));
        Assert.assertEquals((long)4L, (long)((ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies")).length);
    }

    @Test
    public void testEnvEmb() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-embedded");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.transaction.TransactionManager"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        Assert.assertNotNull((Object)environment.get("org.kie.Globals"));
        Assert.assertNotNull((Object)environment.get("org.kie.build.DateFormats"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.time.Calendars"));
        Assert.assertNotNull((Object)environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies"));
        Assert.assertEquals((long)2L, (long)((ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies")).length);
    }

    @Test
    public void testEnvCustomMarshallerNested() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-nested");
        Assert.assertNotNull((Object)environment);
        Assert.assertNotNull((Object)environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies"));
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)1L, (long)objectMarshallingStrategies.length);
        Assert.assertEquals((Object)objectMarshallingStrategies[0].getClass().getName(), (Object)"org.kie.spring.mocks.MockObjectMarshallingStrategy");
    }

    @Test
    public void testEnvCustomMarshallerRef() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-ref");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)1L, (long)objectMarshallingStrategies.length);
        Assert.assertEquals((Object)objectMarshallingStrategies[0].getClass().getName(), (Object)"org.kie.spring.mocks.MockObjectMarshallingStrategy");
    }

    @Test
    public void testEnvMarshallerOrder() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)4L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof ProcessInstanceResolverStrategy));
    }

    @Test
    public void testEnvMarshallerOrderWithCustom() throws Exception {
        Environment environment = (Environment)context.getBean("drools-env-custom-marshaller-mixed");
        Assert.assertNotNull((Object)environment);
        ObjectMarshallingStrategy[] objectMarshallingStrategies = (ObjectMarshallingStrategy[])environment.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        Assert.assertEquals((long)5L, (long)objectMarshallingStrategies.length);
        Assert.assertTrue((boolean)(objectMarshallingStrategies[0] instanceof SerializablePlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[1] instanceof IdentityPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[2] instanceof JPAPlaceholderResolverStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[3] instanceof MockObjectMarshallingStrategy));
        Assert.assertTrue((boolean)(objectMarshallingStrategies[4] instanceof ProcessInstanceResolverStrategy));
    }
}

