/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class KieSpringProcessInstanceMigrationServiceImplTest
extends AbstractJbpmSpringParameterizedTest {
    private static final String ADDTASKAFTERACTIVE_ID_V1 = "process-migration-testv1.AddTaskAfterActive";
    private static final String ADDTASKAFTERACTIVE_ID_V2 = "process-migration-testv2.AddTaskAfterActive";

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-emf/singleton.xml", ProcessInstanceIdContext.get()}};
        return Arrays.asList(data);
    }

    @Override
    @After
    public void cleanup() {
        System.clearProperty("org.kie.txm.factory.class");
        TransactionManagerFactory.resetInstance();
        EntityManagerFactoryManager.get().clear();
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }

    public KieSpringProcessInstanceMigrationServiceImplTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testMigrateSingleProcessInstance() {
        System.setProperty("org.kie.txm.factory.class", "org.kie.spring.persistence.KieSpringTransactionManagerFactory");
        TransactionManagerFactory.resetInstance();
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.persistence.spring.jta", (EntityManagerFactory)this.context.getBean("jbpmEMF", EntityManagerFactory.class));
        RuntimeManager firstManager = this.getManager();
        ((DeploymentDescriptorImpl)((InternalRuntimeManager)firstManager).getDeploymentDescriptor()).setAuditPersistenceUnit("org.jbpm.persistence.spring.jta");
        ((DeploymentDescriptorImpl)((InternalRuntimeManager)firstManager).getDeploymentDescriptor()).setPersistenceUnit("org.jbpm.persistence.spring.jta");
        Assert.assertNotNull((Object)firstManager);
        RuntimeManager secondManager = this.getSecondManager();
        ((DeploymentDescriptorImpl)((InternalRuntimeManager)secondManager).getDeploymentDescriptor()).setAuditPersistenceUnit("org.jbpm.persistence.spring.jta");
        ((DeploymentDescriptorImpl)((InternalRuntimeManager)secondManager).getDeploymentDescriptor()).setPersistenceUnit("org.jbpm.persistence.spring.jta");
        Assert.assertNotNull((Object)secondManager);
        RuntimeEngine engine = firstManager.getRuntimeEngine(this.runtimeManagerContext);
        ProcessInstance instance = engine.getKieSession().startProcess(ADDTASKAFTERACTIVE_ID_V1);
        Assert.assertNotNull((Object)instance);
        long processInstanceId = instance.getId();
        Assert.assertNotNull((Object)processInstanceId);
        ProcessInstanceLog log = engine.getAuditService().findProcessInstance(processInstanceId);
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        Assert.assertEquals((Object)ADDTASKAFTERACTIVE_ID_V1, (Object)log.getProcessId());
        MigrationSpec migrationSpec = new MigrationSpec(firstManager.getIdentifier(), Long.valueOf(processInstanceId), secondManager.getIdentifier(), ADDTASKAFTERACTIVE_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        MigrationReport report = null;
        try {
            report = migrationManager.migrate();
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isSuccessful());
        log = engine.getAuditService().findProcessInstance(processInstanceId);
        Assert.assertEquals((long)1L, (long)log.getStatus().intValue());
        Assert.assertEquals((Object)ADDTASKAFTERACTIVE_ID_V2, (Object)log.getProcessId());
        firstManager.disposeRuntimeEngine(engine);
    }
}

