/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractJbpmServicesTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJbpmServicesTest.class);
    protected static final String ARTIFACT_ID = "test-module";
    protected static final String GROUP_ID = "org.jbpm.test";
    protected static final String VERSION = "1.0.0-SNAPSHOT";

    @BeforeClass
    public static void generalSetup() {
        System.setProperty("java.naming.factory.initial", "org.jbpm.test.util.CloseSafeMemoryContextFactory");
        System.setProperty("org.osjava.sj.root", "target/test-classes/config");
        System.setProperty("org.osjava.jndi.delimiter", "/");
        System.setProperty("org.osjava.sj.jndi.shared", "true");
    }

    @AfterClass
    public static void generalCleanup() {
        System.clearProperty("java.naming.factory.initial");
    }

    protected static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    @Before
    public void setup() {
        AbstractJbpmServicesTest.cleanupSingletonSessionId();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("jbpm/services/hiring.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.deployArtifact((AFReleaseId)releaseId, kJar1, pom);
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources) {
        return this.createKieJar(ks, releaseId, resources, null);
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources, Map<String, String> extraResources) {
        KieBuilder kieBuilder;
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        for (String string : resources) {
            kfs.write("src/main/resources/KBase-test/" + string, ResourceFactory.newClassPathResource((String)string));
        }
        if (extraResources != null) {
            for (Map.Entry entry : extraResources.entrySet()) {
                kfs.write((String)entry.getKey(), ResourceFactory.newByteArrayResource((byte[])((String)entry.getValue()).getBytes()));
            }
        }
        if (!(kieBuilder = ks.newKieBuilder(kfs)).buildAll().getResults().getMessages().isEmpty()) {
            for (Message message : kieBuilder.buildAll().getResults().getMessages()) {
                logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("ksession-test").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }
}

