/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model;

import org.jboss.arquillian.graphene.Graphene;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.model.Persp;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.AdministrationPerspective;
import org.kie.wb.selenium.model.persps.AppsPerspective;
import org.kie.wb.selenium.model.persps.ArtifactRepositoryPerspective;
import org.kie.wb.selenium.model.persps.ContributorsPerspective;
import org.kie.wb.selenium.model.persps.DataSetsPerspective;
import org.kie.wb.selenium.model.persps.HomePerspective;
import org.kie.wb.selenium.model.persps.JobsPerspective;
import org.kie.wb.selenium.model.persps.PeoplePerspective;
import org.kie.wb.selenium.model.persps.PluginManagementPerspective;
import org.kie.wb.selenium.model.persps.ProcessAndTaskDashboardPerspective;
import org.kie.wb.selenium.model.persps.ProcessDefinitionsPerspective;
import org.kie.wb.selenium.model.persps.ProcessDeploymentsPerspective;
import org.kie.wb.selenium.model.persps.ProcessInstancesPerspective;
import org.kie.wb.selenium.model.persps.ProjectAuthoringPerspective;
import org.kie.wb.selenium.model.persps.RuleDeploymentsPerspective;
import org.kie.wb.selenium.model.persps.TasksPerspective;
import org.kie.wb.selenium.model.persps.TimelinePerspective;
import org.kie.wb.selenium.model.widgets.DropdownMenu;
import org.kie.wb.selenium.util.ByUtil;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryNavbar {
    private static final Logger LOG = LoggerFactory.getLogger(PrimaryNavbar.class);
    private static final String NAVBAR_MENU = ".navbar-primary > li.dropdown:has(a:contains('%s'))";
    @FindBy(linkText="Tasks")
    private WebElement tasksLink;
    @FindBy(css="li[title='Reset all Perspective layouts']+li")
    private DropdownMenu logoutMenu;
    @FindBy(css=".uf-workbench-layout > div:last-child")
    private WebElement perspectiveRoot;

    public void logout() {
        this.logoutMenu.selectItem("Log Out");
    }

    public HomePerspective homePage() {
        return this.navigateTo(Persp.HOME_PAGE);
    }

    public TimelinePerspective timeline() {
        return this.navigateTo(Persp.TIMELINE);
    }

    public PeoplePerspective people() {
        return this.navigateTo(Persp.PEOPLE);
    }

    public ProjectAuthoringPerspective projectAuthoring() {
        return this.navigateTo(Persp.PROJECT_AUTHORING);
    }

    public ContributorsPerspective contributors() {
        return this.navigateTo(Persp.CONTRIBUTORS);
    }

    public ArtifactRepositoryPerspective artifactRepository() {
        return this.navigateTo(Persp.ARTIFACT_REPOSITORY);
    }

    public AdministrationPerspective administration() {
        return this.navigateTo(Persp.ADMINISTRATION);
    }

    public ProcessDeploymentsPerspective processDeployments() {
        return this.navigateTo(Persp.PROCESS_DEPLOYMENTS);
    }

    public RuleDeploymentsPerspective ruleDeployments() {
        return this.navigateTo(Persp.RULE_DEPLOYMENTS);
    }

    public JobsPerspective jobs() {
        return this.navigateTo(Persp.JOBS);
    }

    public ProcessDefinitionsPerspective processDefinitions() {
        return this.navigateTo(Persp.PROCESS_DEFINITIONS);
    }

    public ProcessInstancesPerspective processInstances() {
        return this.navigateTo(Persp.PROCESS_INSTANCES);
    }

    public TasksPerspective tasks() {
        return this.navigateTo(Persp.TASKS);
    }

    public ProcessAndTaskDashboardPerspective processAndTaskDashboard() {
        return this.navigateTo(Persp.PROCESS_AND_TASK_DASHBOARD);
    }

    public PluginManagementPerspective pluginManagement() {
        return this.navigateTo(Persp.PLUGIN_MANAGEMENT);
    }

    public AppsPerspective apps() {
        return this.navigateTo(Persp.APPS);
    }

    public DataSetsPerspective dataSets() {
        return this.navigateTo(Persp.DATA_SETS);
    }

    public <T extends AbstractPerspective> T navigateTo(Persp<T> p) {
        LOG.info("Navigating to {}", p);
        if (p == Persp.TASKS) {
            this.tasksLink.click();
        } else {
            this.selectMenuItem(p.getMenu(), p.getName());
        }
        return this.initPerspective(p);
    }

    private void selectMenuItem(String menuName, String itemName) {
        WebElement menuRoot = KieSeleniumTest.driver.findElement(ByUtil.jquery(NAVBAR_MENU, menuName));
        DropdownMenu menu = (DropdownMenu)Graphene.createPageFragment(DropdownMenu.class, (WebElement)menuRoot);
        menu.selectItem(itemName);
    }

    private <T extends AbstractPerspective> T initPerspective(Persp<T> p) {
        AbstractPerspective perspective = (AbstractPerspective)Graphene.createPageFragment(p.getPerspectivePageObjectClass(), (WebElement)this.perspectiveRoot);
        perspective.waitForLoaded();
        return (T)perspective;
    }
}

