/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.util;

import com.google.common.base.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Waits {
    private static final int DEFAULT_TIMEOUT = 15;

    public static void elementVisible(WebDriver driver, By locator, int timeoutSeconds) {
        new WebDriverWait(driver, (long)timeoutSeconds).until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public static WebElement elementPresent(WebDriver driver, By locator, int timeoutSeconds) {
        WebElement elementPresent = (WebElement)new WebDriverWait(driver, (long)timeoutSeconds).until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
        return elementPresent;
    }

    public static WebElement elementPresent(WebDriver driver, By locator) {
        return Waits.elementPresent(driver, locator, 15);
    }

    public static WebElement elementClickable(WebDriver driver, By locator) {
        WebElement clickableElement = (WebElement)new WebDriverWait(driver, 15L).until((Function)ExpectedConditions.elementToBeClickable((By)locator));
        return clickableElement;
    }

    public static boolean isElementPresent(WebDriver driver, By locator) {
        try {
            Waits.elementPresent(driver, locator);
            return true;
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    public static void pause(int miliseconds) {
        try {
            Thread.sleep(miliseconds);
        }
        catch (InterruptedException ex) {
            System.err.println("Pause interrupted");
        }
    }
}

