/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.authoring.ConflictingRepositoriesModal;
import org.kie.wb.selenium.model.persps.authoring.ImportExampleModal;
import org.kie.wb.selenium.util.BusyPopup;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLibraryPerspective
extends AbstractPerspective {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLibraryPerspective.class);
    private static final By WELCOME_MESSAGE_HOLDER = By.id((String)"welcome");
    private static final By OU_REPO_BREADCRUMB = ByJQuery.selector((String)"a:contains('myteam')");

    @Override
    public void waitForLoaded() {
        this.isDisplayed();
    }

    @Override
    public boolean isDisplayed() {
        return Waits.isElementPresent(OU_REPO_BREADCRUMB, 60);
    }

    private ImportExampleModal importExample() {
        BusyPopup.waitForDisappearance();
        Waits.elementPresent((By)ByJQuery.selector((String)"button#import-project-wizard-button"), 20).click();
        return ImportExampleModal.newInstance();
    }

    public boolean isProjectListEmpty() {
        return Waits.isElementPresent(WELCOME_MESSAGE_HOLDER);
    }

    public void openProjectList() {
        Waits.elementPresent(OU_REPO_BREADCRUMB, 20).click();
    }

    public void importDemoProject(String projectName) {
        Waits.elementPresent((By)ByJQuery.selector((String)("button:contains('" + projectName + "')")), 20).click();
    }

    public void buildAndDeployProject() {
        Waits.elementPresent((By)ByJQuery.selector((String)"button:contains('Build & Deploy')"), 20).click();
        this.possiblyOverrideGavConflict();
    }

    public void importStockExampleProject(String targetRepo, String targetOrgUnit, String ... projects) {
        ImportExampleModal modal = this.importExample();
        modal.selectStockRepository();
        modal.selectProjects(projects);
        modal.setTargetRepoAndOrgUnit(targetRepo, targetOrgUnit);
    }

    public void importCustomExampleProject(Repository repo, String targetRepo, String targetOrgUnit, String ... projects) {
        ImportExampleModal modal = this.importExample();
        modal.selectCustomRepository(repo.getUrl());
        modal.selectProjects(projects);
        modal.setTargetRepoAndOrgUnit(targetRepo, targetOrgUnit);
    }

    private void possiblyOverrideGavConflict() {
        try {
            ConflictingRepositoriesModal modal = ConflictingRepositoriesModal.newInstance();
            modal.overrideArtifactInMavenRepo();
        }
        catch (NoSuchElementException | TimeoutException ignored) {
            LOG.info("Modal showing GAV conflict didn't appear");
        }
    }
}

