/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model;

import org.jboss.arquillian.graphene.Graphene;
import org.kie.wb.selenium.model.KieSeleniumTest;
import org.kie.wb.selenium.model.Persp;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.AdminPagePerspective;
import org.kie.wb.selenium.model.persps.ProcessAndTaskDashboardPerspective;
import org.kie.wb.selenium.model.persps.ProjectLibraryPerspective;
import org.kie.wb.selenium.model.widgets.DropdownMenu;
import org.kie.wb.selenium.util.BusyPopup;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryNavbar {
    private static final Logger LOG = LoggerFactory.getLogger(PrimaryNavbar.class);
    private static final String NAVBAR_MENU = ".navbar li.dropdown:has(a#mega-menu-dropdown)";
    private static final String INFO_ALERT = "div[class*='alert-info']";
    @FindBy(css="#mega-menu > nav")
    private WebElement navbar;
    @FindBy(css="li[title='Reset all Perspective layouts']+li")
    private DropdownMenu logoutMenu;
    @FindBy(css=".uf-workbench-layout")
    private WebElement perspectiveRoot;
    @FindBy(css=".navbar-right a[title=Admin]")
    private WebElement adminLink;

    public void logout() {
        this.logoutMenu.selectItem("Log Out");
    }

    public ProjectLibraryPerspective projectAuthoring() {
        return this.navigateTo(Persp.PROJECTS);
    }

    public AdminPagePerspective admin() {
        this.adminLink.click();
        return this.initPerspective(Persp.ADMIN);
    }

    public ProcessAndTaskDashboardPerspective processAndTaskDashboard() {
        return this.navigateTo(Persp.PROCESS_AND_TASK_DASHBOARD);
    }

    public <T extends AbstractPerspective> T navigateTo(Persp<T> p) {
        LOG.info("Navigating to {}", p);
        this.selectMenuItem(p.getMenu(), p.getName());
        return this.initPerspective(p);
    }

    private void selectMenuItem(String menuName, String itemName) {
        Waits.elementAbsent(ByUtil.jquery(INFO_ALERT, new Object[0]));
        if ("N/A".equals(menuName)) {
            By itemLink = ByUtil.jquery("a[title='%s']", itemName);
            Waits.elementClickable(itemLink);
            BusyPopup.retryClickUntilPopupDisappears(this.navbar.findElement(itemLink));
        } else {
            WebElement menuRoot = KieSeleniumTest.driver.findElement(ByUtil.jquery(NAVBAR_MENU, new Object[0]));
            DropdownMenu menu = (DropdownMenu)Graphene.createPageFragment(DropdownMenu.class, (WebElement)menuRoot);
            menu.selectItem(itemName);
        }
    }

    public <T extends AbstractPerspective> T initPerspective(Persp<T> p) {
        AbstractPerspective perspective = (AbstractPerspective)Graphene.createPageFragment(p.getPerspectivePageObjectClass(), (WebElement)this.perspectiveRoot);
        perspective.waitForLoaded();
        return (T)perspective;
    }
}

