/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps.authoring;

import java.util.Arrays;
import org.kie.wb.selenium.model.widgets.ModalDialog;
import org.kie.wb.selenium.util.ByUtil;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class ImportExampleModal
extends ModalDialog {
    @FindBy(id="stockRadio")
    private WebElement stockRepositoryRadioOption;
    @FindBy(id="customRadio")
    private WebElement customRepositoryRadioOption;
    @FindBy(id="repositoryUrlInput")
    private WebElement repoUrlInput;
    @FindBy(id="targetRepositoryTextBox")
    private WebElement targetRepoInput;

    public static ImportExampleModal newInstance() {
        return ModalDialog.newInstance(ImportExampleModal.class, "Import Example");
    }

    public void selectStockRepository() {
        this.stockRepositoryRadioOption.click();
        this.next();
        Waits.elementPresent(By.id((String)"projects"));
    }

    public void selectCustomRepository(String repoUrl) {
        this.customRepositoryRadioOption.click();
        this.repoUrlInput.clear();
        this.repoUrlInput.sendKeys(new CharSequence[]{repoUrl});
        this.repoUrlInput.sendKeys(new CharSequence[]{Keys.TAB});
        this.next();
        Waits.elementPresent(By.id((String)"projects"));
    }

    public void selectProjects(String ... projects) {
        Arrays.stream(projects).forEach(this::selectProject);
        this.next();
    }

    private void selectProject(String project) {
        By projCheckboxLoc = ByUtil.xpath("//input[following-sibling::span[contains(text(),'%s')]]", project);
        WebElement checkbox = Waits.elementPresent(projCheckboxLoc);
        checkbox.click();
    }

    public void setTargetRepo(String repoName) {
        this.targetRepoInput.sendKeys(new CharSequence[]{repoName});
        this.targetRepoInput.click();
        this.finish();
    }
}

