/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.util;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.kie.wb.selenium.model.PageObject;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusyPopup
extends PageObject {
    private static final String GLASS_CSS_CLASS = "gwt-PopupPanelGlass";
    private static final Logger LOG = LoggerFactory.getLogger(BusyPopup.class);

    public static void waitForDisappearance() {
        By glass = By.className((String)GLASS_CSS_CLASS);
        ((IsElementBuilder)Graphene.waitModel().until().element(glass).is().not()).present();
        Waits.pause(500);
    }

    public static void retryClickUntilPopupDisappears(WebElement element) {
        int triesRemaining = 100;
        boolean firstTime = true;
        while (triesRemaining > 0) {
            try {
                element.click();
                return;
            }
            catch (WebDriverException e) {
                if (BusyPopup.isGlassException(e)) {
                    --triesRemaining;
                    if (firstTime) {
                        firstTime = false;
                        String firstLineOfExceptionMessage = e.getMessage().split("\n")[0];
                        LOG.warn("Clicking element {} failed: {}", (Object)element, (Object)firstLineOfExceptionMessage);
                    } else {
                        LOG.debug("Retrying click, {} tries remaining.", (Object)triesRemaining);
                    }
                    Waits.pause(100);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isGlassException(WebDriverException e) {
        return e.getMessage().contains("Other element would receive the click") && e.getMessage().contains(GLASS_CSS_CLASS);
    }
}

