/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.wb.selenium.util.GrapheneUtil;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class ScreenshotOnFailure
extends TestWatcher {
    private final File screenshotDir = this.initScreenshotDir();

    protected void failed(Throwable e, Description description) {
        String testClassName = description.getTestClass().getSimpleName();
        String testMethodName = description.getMethodName();
        String filename = testClassName + "_" + testMethodName;
        this.takeScreenshot(filename);
        this.savePageHtmlSource(filename);
    }

    private void takeScreenshot(String filename) {
        File tmpScreenshot = (File)((TakesScreenshot)GrapheneUtil.getDriver()).getScreenshotAs(OutputType.FILE);
        File targetScreenshot = new File(this.screenshotDir, filename + ".png");
        try {
            FileUtils.copyFile((File)tmpScreenshot, (File)targetScreenshot);
            System.out.println("Screenshot on failure taken: " + targetScreenshot);
        }
        catch (IOException ex) {
            System.err.print("Failed to take a screenshot on failed test " + filename + " " + ex.getMessage());
        }
    }

    private void savePageHtmlSource(String filename) {
        String pageSource = GrapheneUtil.getDriver().getPageSource();
        File targetFile = new File(this.screenshotDir, filename + ".html");
        try {
            FileUtils.writeStringToFile((File)targetFile, (String)pageSource, (String)"UTF-8");
            System.out.println("Saved page HTML source on failure: " + targetFile);
        }
        catch (IOException ex) {
            System.err.println("Failed to save page HTML source " + ex.getMessage());
        }
    }

    private File initScreenshotDir() {
        boolean mkdirSuccess;
        String dir = System.getProperty("selenium.screenshots.dir");
        if (dir == null) {
            throw new IllegalStateException("Property selenium.screenshots.dir (where screenshot taken by WebDriver will be put) must be defined: " + dir);
        }
        File scd = new File(dir);
        if (!scd.exists() && !(mkdirSuccess = scd.mkdir())) {
            throw new IllegalStateException("Creation of screenshots dir failed " + scd);
        }
        if (!scd.canWrite()) {
            throw new IllegalStateException("The screenshotDir must be writable" + scd);
        }
        return scd;
    }
}

