/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.ProjectRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;

@RunWith(value=Parameterized.class)
public class ProjectAccessIntegrationTest
extends AccessRestTestBase {
    private static final String ORG_UNIT = "projectAccessTestOrgUnit";
    private static final String REPOSITORY = "projectAccessTestRepository";

    public ProjectAccessIntegrationTest(User user) {
        super(user);
    }

    @BeforeClass
    public static void createRepository() {
        ProjectAccessIntegrationTest.createOrganizationalUnit(ORG_UNIT);
        ProjectAccessIntegrationTest.createNewRepository(ORG_UNIT, REPOSITORY);
    }

    @Test
    public void testCreateProject() {
        String name = "createProjectWith" + this.user.getUserName();
        ProjectRequest project = new ProjectRequest();
        project.setName(name);
        this.assertOperation(() -> this.roleClient.createProject(REPOSITORY, project));
    }

    @Test
    public void testDeleteProject() {
        String name = "deleteProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.deleteProject(REPOSITORY, name));
    }

    @Test
    public void testGetProjects() {
        this.assertOperation(() -> this.roleClient.getProjects(REPOSITORY));
    }

    @Test
    public void testCompileProject() {
        String name = "compileProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.compileProject(REPOSITORY, name));
    }

    @Test
    public void testTestProject() {
        String name = "testProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.testProject(REPOSITORY, name));
    }

    @Test
    public void testInstallProject() {
        String name = "installProjectWith" + this.user.getUserName() + Math.random();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.installProject(REPOSITORY, name));
    }

    @Test
    public void testDeployProject() {
        String name = "deployProjectWith" + this.user.getUserName() + Math.random();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.deployProject(REPOSITORY, name));
    }

    private void createProject(String name) {
        ProjectRequest project = new ProjectRequest();
        project.setName(name);
        client.createProject(REPOSITORY, project);
    }
}

