/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.KieWorkbenchEntryPoint;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieWorkbenchEntryPointTest {
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private Caller<AuthenticationService> authService;
    @Mock
    private AuthenticationService authServiceImpl;
    @Spy
    @InjectMocks
    private KieWorkbenchEntryPoint entryPoint;

    @Before
    public void setup() {
        this.entryPoint.authService = this.authService;
    }

    @Test
    public void logoutCommandTest() {
        KieWorkbenchEntryPoint.LogoutCommand logoutCommand = (KieWorkbenchEntryPoint.LogoutCommand)Mockito.spy((Object)new KieWorkbenchEntryPoint.LogoutCommand(this.entryPoint));
        logoutCommand.execute();
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).savePerspectiveState((Command)Matchers.any(Command.class));
    }

    @Test
    public void logoutCommandRedirectIncludesLocaleTest() throws Throwable {
        KieWorkbenchEntryPoint.LogoutCommand logoutCommand = (KieWorkbenchEntryPoint.LogoutCommand)Mockito.spy((Object)new KieWorkbenchEntryPoint.LogoutCommand(this.entryPoint){

            void doRedirect(String url) {
            }

            String getGWTModuleBaseURL() {
                return "/gwtModule/";
            }

            String getGWTModuleName() {
                return "gwtModule";
            }

            String getLocale() {
                return "en_GB";
            }
        });
        Mockito.when((Object)this.authService.call((RemoteCallback)Matchers.any(RemoteCallback.class))).thenAnswer((Answer)new Answer<AuthenticationService>(){

            public AuthenticationService answer(InvocationOnMock invocation) throws Throwable {
                ((RemoteCallback)invocation.getArguments()[0]).callback(null);
                return KieWorkbenchEntryPointTest.this.authServiceImpl;
            }
        });
        logoutCommand.execute();
        ArgumentCaptor postSaveStateCommandCaptor = ArgumentCaptor.forClass(Command.class);
        ArgumentCaptor redirectURLCaptor = ArgumentCaptor.forClass(String.class);
        ((PerspectiveManager)Mockito.verify((Object)this.perspectiveManager)).savePerspectiveState((Command)postSaveStateCommandCaptor.capture());
        Command postSaveStateCommand = (Command)postSaveStateCommandCaptor.getValue();
        postSaveStateCommand.execute();
        ((KieWorkbenchEntryPoint.LogoutCommand)Mockito.verify((Object)logoutCommand)).getRedirectURL();
        ((KieWorkbenchEntryPoint.LogoutCommand)Mockito.verify((Object)logoutCommand)).doRedirect((String)redirectURLCaptor.capture());
        ((AuthenticationService)Mockito.verify((Object)this.authServiceImpl)).logout();
        String redirectURL = (String)redirectURLCaptor.getValue();
        Assert.assertTrue((boolean)redirectURL.contains("/logout.jsp?locale=en_GB"));
    }
}

