/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client.perspectives;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.perspectives.AdministrationPerspective;
import org.uberfire.mvp.Command;
import org.uberfire.security.authz.ResourceActionRef;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdministrationPerspectiveTest {
    private AdministrationPerspective perspective;

    @Before
    public void setUp() {
        this.perspective = new AdministrationPerspective();
        this.perspective.init();
    }

    @Test
    public void testCreateRepoMenus() {
        Menus menus = this.perspective.getMenus();
        menus.accept((MenuVisitor)new BaseMenuVisitor(){

            public void visit(MenuItemCommand menuItemCommand) {
                Command command = menuItemCommand.getCommand();
                List actionRefList = menuItemCommand.getResourceActions();
                if (command != null) {
                    if (command.equals(AdministrationPerspectiveTest.this.perspective.getNewRepoCommand())) {
                        Assert.assertEquals((long)actionRefList.size(), (long)1L);
                        ResourceActionRef resourceRef = (ResourceActionRef)actionRefList.get(0);
                        Assert.assertEquals((Object)resourceRef.getResource().getResourceType(), (Object)Repository.RESOURCE_TYPE);
                        Assert.assertEquals((Object)resourceRef.getAction(), (Object)RepositoryAction.CREATE);
                    } else if (command.equals(AdministrationPerspectiveTest.this.perspective.getCloneRepoCommand())) {
                        Assert.assertEquals((long)actionRefList.size(), (long)1L);
                        ResourceActionRef resourceRef = (ResourceActionRef)actionRefList.get(0);
                        Assert.assertEquals((Object)resourceRef.getResource().getResourceType(), (Object)Repository.RESOURCE_TYPE);
                        Assert.assertEquals((Object)resourceRef.getAction(), (Object)RepositoryAction.CREATE);
                    }
                }
            }
        });
    }
}

