/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.addon.TypeResolver;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.ClassFieldInspector;

public class TypeDeclarationUtils {
    public static String lookupSimpleNameByImports(String name, AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, ClassLoader loader) {
        Class<?> typeClass = null;
        if (TypeDeclarationUtils.isQualified(name)) {
            typeClass = TypeDeclarationUtils.getClassForType(name, loader);
        }
        if (typeClass == null) {
            for (ImportDescr id : packageDescr.getImports()) {
                int separator;
                String imp = id.getTarget();
                String tail = imp.substring((separator = imp.lastIndexOf(46)) + 1);
                if (tail.equals(name)) {
                    typeClass = TypeDeclarationUtils.getClassForType(imp, loader);
                    if (typeClass != null) {
                        return typeClass.getCanonicalName();
                    }
                    return imp;
                }
                if (!tail.equals("*") || (typeClass = TypeDeclarationUtils.getClassForType(imp.substring(0, imp.length() - 1) + name, loader)) == null) continue;
                String resolvedNamespace = imp.substring(0, separator);
                if (resolvedNamespace.equals(typeDescr.getNamespace()) || !name.equals(typeDescr.getType().getName()) || TypeDeclarationUtils.isCompatible(typeClass, typeDescr)) break;
                typeClass = null;
            }
        }
        return typeClass != null ? typeClass.getName() : name;
    }

    public static Class<?> getExistingDeclarationClass(AbstractClassTypeDeclarationDescr typeDescr, PackageRegistry reg) {
        try {
            return reg == null ? null : reg.getTypeResolver().resolveType(typeDescr.getFullTypeName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String resolveType(String klass, PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        String arraySuffix = "";
        int arrayIndex = klass.indexOf("[");
        if (arrayIndex >= 0) {
            arraySuffix = klass.substring(arrayIndex);
            klass = klass.substring(0, arrayIndex);
        }
        String temp = klass;
        while (temp.length() > 0) {
            for (ImportDescr id : packageDescr.getImports()) {
                String fqKlass = id.getTarget();
                if (!fqKlass.endsWith("." + temp)) continue;
                fqKlass = fqKlass.substring(0, fqKlass.lastIndexOf(temp)) + klass;
                return arrayIndex < 0 ? fqKlass : fqKlass + arraySuffix;
            }
            temp = temp.substring(0, Math.max(0, temp.lastIndexOf(46)));
        }
        if (pkgRegistry != null) {
            for (String declaredName : pkgRegistry.getPackage().getTypeDeclarations().keySet()) {
                TypeDeclaration typeDeclaration;
                if (!declaredName.equals(klass) || (typeDeclaration = pkgRegistry.getPackage().getTypeDeclaration(declaredName)).getTypeClass() == null) continue;
                klass = typeDeclaration.getTypeClass().getName();
            }
        }
        if (klass != null && !klass.contains(".") && packageDescr.getNamespace() != null && !packageDescr.getNamespace().isEmpty()) {
            for (AbstractClassTypeDeclarationDescr td : packageDescr.getClassAndEnumDeclarationDescrs()) {
                if (!klass.equals(td.getTypeName()) || !td.getType().getFullName().contains(".")) continue;
                klass = td.getType().getFullName();
            }
        }
        return arrayIndex < 0 ? klass : klass + arraySuffix;
    }

    public static String typeName2ClassName(String type, ClassLoader loader) {
        Class<?> cls = TypeDeclarationUtils.getClassForType(type, loader);
        return cls != null ? cls.getName() : type;
    }

    public static Class<?> getClassForType(String type, ClassLoader loader) {
        Class<?> cls = null;
        if (!TypeDeclarationUtils.isQualified(type)) {
            return null;
        }
        String className = type;
        while (true) {
            try {
                cls = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                int separator = className.lastIndexOf(46);
                if (separator < 0) break;
                className = className.substring(0, separator) + "$" + className.substring(separator + 1);
                continue;
            }
            break;
        }
        return cls;
    }

    public static boolean isCompatible(Class<?> typeClass, AbstractClassTypeDeclarationDescr typeDescr) {
        try {
            if (typeDescr.getFields().isEmpty()) {
                return true;
            }
            Class<?> sup = typeClass.getSuperclass();
            if (sup == null) {
                return true;
            }
            if (!sup.getName().equals(typeDescr.getSupertTypeFullName())) {
                return false;
            }
            ClassFieldInspector cfi = new ClassFieldInspector(typeClass, false);
            if (cfi.getGetterMethods().size() != typeDescr.getFields().size()) {
                return false;
            }
            for (String fieldName : cfi.getFieldTypes().keySet()) {
                Class fieldType;
                if (!typeDescr.getFields().containsKey(fieldName)) {
                    return false;
                }
                String fieldTypeName = typeDescr.getFields().get(fieldName).getPattern().getObjectType();
                if (fieldTypeName.equals((fieldType = (Class)cfi.getFieldTypes().get(fieldName)).getName()) && fieldTypeName.equals(fieldType.getSimpleName())) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isQualified(String name) {
        return !StringUtils.isEmpty((CharSequence)name) && name.indexOf(46) >= 0;
    }

    public static boolean isNovelClass(AbstractClassTypeDeclarationDescr typeDescr, PackageRegistry reg) {
        return TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, reg) == null;
    }

    public static String rewriteInitExprWithImports(String expr, TypeResolver typeResolver) {
        if (expr == null) {
            return null;
        }
        if (typeResolver == null) {
            return expr;
        }
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        boolean inTypeName = false;
        boolean afterDot = false;
        int typeStart = 0;
        for (int i = 0; i < expr.length(); ++i) {
            char ch = expr.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                if (!(inTypeName || inQuotes || afterDot)) {
                    typeStart = i;
                    inTypeName = true;
                }
            } else if (!Character.isJavaIdentifierPart(ch)) {
                if (ch == '\"') {
                    inQuotes = !inQuotes;
                } else if (ch == '.' && !inQuotes) {
                    afterDot = true;
                } else if (!Character.isSpaceChar(ch)) {
                    afterDot = false;
                }
                if (inTypeName) {
                    inTypeName = false;
                    String type = expr.substring(typeStart, i);
                    sb.append(TypeDeclarationUtils.getFullTypeName(type, typeResolver));
                }
            }
            if (inTypeName) continue;
            sb.append(ch);
        }
        if (inTypeName) {
            String type = expr.substring(typeStart);
            sb.append(TypeDeclarationUtils.getFullTypeName(type, typeResolver));
        }
        return sb.toString();
    }

    private static String getFullTypeName(String type, TypeResolver typeResolver) {
        if (TypeDeclarationUtils.isLiteralOrKeyword(type)) {
            return type;
        }
        try {
            return typeResolver.getFullTypeName(type);
        }
        catch (ClassNotFoundException e) {
            return type;
        }
    }

    private static boolean isLiteralOrKeyword(String type) {
        return "true".equals(type) || "false".equals(type) || "null".equals(type) || "new".equals(type);
    }

    public static String toBuildableType(String className, ClassLoader loader) {
        int arrayDim = BuildUtils.externalArrayDimSize((String)className);
        String prefix = "";
        String coreType = arrayDim == 0 ? className : className.substring(0, className.indexOf("["));
        coreType = TypeDeclarationUtils.typeName2ClassName(coreType, loader);
        if (arrayDim > 0) {
            coreType = BuildUtils.getTypeDescriptor((String)coreType);
            for (int j = 0; j < arrayDim; ++j) {
                prefix = "[" + prefix;
            }
        } else {
            return coreType;
        }
        return prefix + coreType;
    }
}

