/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.drools.Person;
import org.drools.core.addon.ClassTypeResolver;
import org.drools.core.addon.TypeResolver;
import org.drools.mvelcompiler.MvelCompiler;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.context.MvelCompilerContext;

interface CompilerTest {
    default public void test(Consumer<MvelCompilerContext> testFunction, String actualExpression, String expectedResult, Consumer<ParsingResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        ParsingResult compiled = new MvelCompiler(mvelCompilerContext).compile(actualExpression);
        AssertionsForInterfaceTypes.assertThat((String)compiled.resultAsString()).isEqualToIgnoringWhitespace((CharSequence)expectedResult);
        resultAssert.accept(compiled);
    }

    default public void test(String actualExpression, String expectedResult, Consumer<ParsingResult> resultAssert) {
        this.test(id -> {}, actualExpression, expectedResult, resultAssert);
    }

    default public void test(Consumer<MvelCompilerContext> testFunction, String actualExpression, String expectedResult) {
        this.test(testFunction, actualExpression, expectedResult, t -> {});
    }

    default public void test(String actualExpression, String expectedResult) {
        this.test(d -> {}, actualExpression, expectedResult, t -> {});
    }

    default public Collection<String> allUsedBindings(ParsingResult result) {
        return new ArrayList<String>(result.getUsedBindings());
    }
}

