/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.function.Consumer;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.ModifyCompiler;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.junit.jupiter.api.Test;

public class ModifyCompilerTest
implements CompilerTest {
    @Test
    public void testUncompiledMethod() {
        this.test("{modify( (List)$toEdit.get(0) ){ setEnabled( true ) }}", "{ ((List) $toEdit.get(0)).setEnabled(true); }", (ParsingResult result) -> AssertionsForInterfaceTypes.assertThat(this.allUsedBindings((ParsingResult)result)).isEmpty());
    }

    @Test
    public void testNestedModify() {
        this.test("{    if ($fact.getResult() != null) {\n        $fact.setResult(\"OK\");\n    } else {\n        modify ($fact) {\n            setResult(\"FIRST\")\n        }\n    }}", " { if ($fact.getResult() != null) {   $fact.setResult(\"OK\"); } else { ($fact).setResult(\"FIRST\"); update($fact); } } ", (ParsingResult result) -> AssertionsForInterfaceTypes.assertThat(this.allUsedBindings((ParsingResult)result)).containsExactlyInAnyOrder((Object[])new String[]{"$fact"}));
    }

    @Override
    public void test(Consumer<MvelCompilerContext> testFunction, String actualExpression, String expectedResult, Consumer<ParsingResult> resultAssert) {
        ParsingResult compiled = new ModifyCompiler().compile(actualExpression);
        AssertionsForInterfaceTypes.assertThat((String)compiled.resultAsString()).isEqualToIgnoringWhitespace((CharSequence)expectedResult);
        resultAssert.accept(compiled);
    }
}

