/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvelcompiler.ast.IntegerLiteralExpressionT;
import org.drools.mvelcompiler.ast.MethodCallExprT;
import org.drools.mvelcompiler.ast.SimpleNameTExpr;
import org.drools.mvelcompiler.ast.TypedExpression;

public class PostProcessRHSPhase
implements DrlGenericVisitor<Optional<TypedExpression>, Void> {
    private TypedExpression lhs;

    PostProcessRHSPhase() {
    }

    public Optional<TypedExpression> invoke(TypedExpression rhs, TypedExpression lhs) {
        this.lhs = lhs;
        return Optional.ofNullable(rhs).flatMap(r -> (Optional)r.toJavaExpression().accept((GenericVisitor)this, null));
    }

    public Optional<TypedExpression> defaultMethod(Node n, Void context) {
        return Optional.empty();
    }

    public Optional<TypedExpression> visit(IntegerLiteralExpr n, Void arg) {
        return this.lhs.getType().flatMap(t -> {
            if (BigDecimal.class.equals(t)) {
                return this.asBigDecimalValueOf(n);
            }
            return Optional.empty();
        });
    }

    private Optional<TypedExpression> asBigDecimalValueOf(IntegerLiteralExpr n) {
        Optional<TypedExpression> bigDecimal = Optional.of(new SimpleNameTExpr(BigDecimal.class.getCanonicalName(), null));
        List<TypedExpression> arguments = Collections.singletonList(new IntegerLiteralExpressionT(new IntegerLiteralExpr(n.asInt())));
        MethodCallExprT valueOf = new MethodCallExprT("valueOf", bigDecimal, arguments, Optional.of(BigDecimal.class));
        return Optional.of(valueOf);
    }
}

