/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.explainability.integrationtests.opennlp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.global.pdp.PartialDependencePlotExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.SimplePrediction;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class OpenNLPPDPExplainerTest {
    OpenNLPPDPExplainerTest() {
    }

    @Test
    void testOpenNLPLangDetect() throws Exception {
        PartialDependencePlotExplainer partialDependencePlotExplainer = new PartialDependencePlotExplainer();
        InputStream is = this.getClass().getResourceAsStream("/opennlp/langdetect-183.bin");
        LanguageDetectorModel languageDetectorModel = new LanguageDetectorModel(is);
        LanguageDetectorME languageDetector = new LanguageDetectorME(languageDetectorModel);
        PredictionProvider model = arg_0 -> OpenNLPPDPExplainerTest.lambda$testOpenNLPLangDetect$1((LanguageDetector)languageDetector, arg_0);
        List<String> texts = List.of("we want your money", "please reply quickly", "you are the lucky winner", "italiani, spaghetti pizza mandolino", "guten tag", "allez les bleus", "daje roma");
        ArrayList<SimplePrediction> predictions = new ArrayList<SimplePrediction>();
        for (String text : texts) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            features.add(FeatureFactory.newFulltextFeature((String)"text", (String)text));
            PredictionInput predictionInput = new PredictionInput(features);
            PredictionOutput predictionOutput = (PredictionOutput)((List)model.predictAsync(List.of(predictionInput)).get()).get(0);
            predictions.add(new SimplePrediction(predictionInput, predictionOutput));
        }
        List pdps = partialDependencePlotExplainer.explainFromPredictions(model, predictions);
        Assertions.assertThat((List)pdps).isNotEmpty();
    }

    private static /* synthetic */ CompletableFuture lambda$testOpenNLPLangDetect$1(LanguageDetector languageDetector, List inputs) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PredictionOutput> results = new ArrayList<PredictionOutput>();
            for (PredictionInput predictionInput : inputs) {
                StringBuilder builder = new StringBuilder();
                for (Feature f : predictionInput.getFeatures()) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(f.getValue().asString());
                }
                Language language = languageDetector.predictLanguage((CharSequence)builder.toString());
                PredictionOutput predictionOutput = new PredictionOutput(List.of(new Output("lang", Type.TEXT, new Value((Object)language.getLang()), language.getConfidence())));
                results.add(predictionOutput);
            }
            return results;
        });
    }
}

