/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.Decision;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.grafana.JGrafana;
import org.kie.kogito.grafana.dmn.SupportedDecisionTypes;
import org.kie.kogito.grafana.model.functions.GrafanaFunction;
import org.kie.kogito.grafana.model.functions.Label;
import org.kie.kogito.grafana.model.panel.PanelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger(GrafanaConfigurationWriter.class);
    private static final String AUDIT_LINK_NAME = "Audit UI";
    private static final String AUDIT_LINK_URL_PLACEHOLDER = "${{urlPlaceholder}}";

    private GrafanaConfigurationWriter() {
    }

    public static String generateOperationalDashboard(String templatePath, String dashboardName, String handlerName, KogitoGAV gav, boolean generateAuditLink) {
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, handlerName, gav.getArtifactId(), gav.getVersion());
        JGrafana jgrafana = GrafanaConfigurationWriter.initialize(template, String.format("%s - Operational Dashboard", dashboardName), generateAuditLink);
        return GrafanaConfigurationWriter.serialize(jgrafana);
    }

    public static String generateDomainSpecificDMNDashboard(String templatePath, String dashboardName, String endpoint, KogitoGAV gav, List<Decision> decisions, boolean generateAuditLink) {
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, endpoint, gav.getArtifactId(), gav.getVersion());
        JGrafana jgrafana = GrafanaConfigurationWriter.initialize(template, String.format("%s - Domain Dashboard", dashboardName), generateAuditLink);
        for (Decision decision : decisions) {
            QName type = decision.getVariable().getTypeRef();
            if (type == null) {
                logger.warn(String.format("DMN typeref for the decision \"%s\" with node id \"%s\" is null.", decision.getName(), decision.getId()));
                continue;
            }
            if (!SupportedDecisionTypes.isSupported(type.getLocalPart())) continue;
            String metricBody = "dmn_result";
            ArrayList<Label> labels = new ArrayList<Label>();
            labels.add(new Label("endpoint", "\"" + endpoint + "\""));
            labels.add(new Label("decision", "\"" + decision.getName() + "\""));
            labels.add(new Label("artifactId", "\"" + gav.getArtifactId() + "\""));
            labels.add(new Label("version", "\"" + gav.getVersion() + "\""));
            GrafanaFunction grafanaFunction = SupportedDecisionTypes.getGrafanaFunction(type.getLocalPart()).orElseThrow(() -> new RuntimeException("Mismatch between supported Grafana DMN Types and defined functions"));
            jgrafana.addPanel(PanelType.GRAPH, "Decision " + decision.getName(), grafanaFunction.render(metricBody, labels), SupportedDecisionTypes.getYAxis(type.getLocalPart()));
        }
        return GrafanaConfigurationWriter.serialize(jgrafana);
    }

    public static String generateDomainSpecificDrlDashboard(String templatePath, String dashboardName, String endpoint, KogitoGAV gav, boolean generateAuditLink) {
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, endpoint, gav.getArtifactId(), gav.getVersion());
        JGrafana jgrafana = GrafanaConfigurationWriter.initialize(template, String.format("%s - Domain Dashboard", dashboardName), generateAuditLink);
        return GrafanaConfigurationWriter.serialize(jgrafana);
    }

    private static JGrafana initialize(String template, String name, boolean generateAuditLink) {
        JGrafana jgrafana;
        try {
            jgrafana = JGrafana.parse(template).setTitle(name);
        }
        catch (IOException e) {
            logger.error(String.format("Could not parse the grafana template for the dashboard %s", name), (Throwable)e);
            throw new IllegalArgumentException("Could not parse the dashboard template.", e);
        }
        if (generateAuditLink) {
            jgrafana.addLink(AUDIT_LINK_NAME, AUDIT_LINK_URL_PLACEHOLDER);
        }
        return jgrafana;
    }

    private static String serialize(JGrafana jgrafana) {
        try {
            return jgrafana.serialize();
        }
        catch (IOException e) {
            logger.error("Could not serialize the grafana dashboard");
            throw new UncheckedIOException("Could not serialize the grafana dashboard.", e);
        }
    }

    public static String buildDashboardName(Optional<KogitoGAV> gav, String handlerName) {
        if (gav.isPresent()) {
            return String.format("%s_%s - %s", gav.get().getArtifactId(), gav.get().getVersion(), handlerName);
        }
        return handlerName;
    }

    private static String readStandardDashboard(String templatePath) {
        InputStream is = GrafanaConfigurationWriter.class.getResourceAsStream(templatePath);
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }

    private static String customizeTemplate(String template, String handlerName, String artifactId, String version) {
        template = template.replaceAll("\\$handlerName\\$", handlerName);
        template = template.replaceAll("\\$id\\$", String.valueOf(new Random().nextInt()));
        template = template.replaceAll("\\$uid\\$", UUID.randomUUID().toString());
        template = template.replaceAll("\\$gavArtifactId\\$", artifactId);
        template = template.replaceAll("\\$gavVersion\\$", version);
        return template;
    }
}

