/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.model.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.model.functions.BaseExpression;
import org.kie.kogito.grafana.model.functions.Label;

public class BaseExpressionTest {
    @Test
    public void testBaseExpressionRender() {
        BaseExpression baseExpression = new BaseExpression("prefix", "suffix");
        String result = baseExpression.render("body", Collections.singletonList(new Label("test", "test")));
        Assertions.assertThat((String)result).isEqualTo("prefix_body_suffix{test=test}");
    }

    @Test
    public void testBaseExpressionRenderWithMultipleLabels() {
        BaseExpression baseExpression = new BaseExpression("prefix", "suffix");
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.add(new Label("first", "value"));
        labels.add(new Label("second", "\"value\""));
        String result = baseExpression.render("body", labels);
        Assertions.assertThat((String)result).isEqualTo("prefix_body_suffix{first=value,second=\"value\"}");
    }
}

