/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.dmn;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.dmn.BooleanType;
import org.kie.kogito.grafana.dmn.DaysAndTimeDurationType;
import org.kie.kogito.grafana.dmn.LocalDateType;
import org.kie.kogito.grafana.dmn.LocalTimeType;
import org.kie.kogito.grafana.dmn.NumberType;
import org.kie.kogito.grafana.dmn.StringType;
import org.kie.kogito.grafana.dmn.TimeAndDateType;
import org.kie.kogito.grafana.dmn.YearsAndMonthsDurationType;
import org.kie.kogito.grafana.model.functions.Label;

public class DmnTypesTest {
    @Test
    public void testBooleanTypeRender() {
        BooleanType booleanType = new BooleanType();
        String result = booleanType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("sum by (identifier) (increase(boolean_dmn_metrics_total{id=test}[1m]))");
    }

    @Test
    public void testStringTypeRender() {
        StringType stringType = new StringType();
        String result = stringType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("sum by (identifier) (increase(string_dmn_metrics_total{id=test}[1m]))");
    }

    @Test
    public void testDaysAndTimeDurationTypeTypeRender() {
        DaysAndTimeDurationType daysAndTimeDurationType = new DaysAndTimeDurationType();
        String result = daysAndTimeDurationType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(days_and_time_duration_dmn_metrics_sum{id=test}[1m])))/(sum(increase(days_and_time_duration_dmn_metrics_count{id=test}[1m])))");
    }

    @Test
    public void testLocalDateTypeRender() {
        LocalDateType localDateType = new LocalDateType();
        String result = localDateType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(date_dmn_metrics_sum{id=test}[1m])))/(sum(increase(date_dmn_metrics_count{id=test}[1m])))");
    }

    @Test
    public void testLocalTimeTypeRender() {
        LocalTimeType localTimeType = new LocalTimeType();
        String result = localTimeType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(time_dmn_metrics_sum{id=test}[1m])))/(sum(increase(time_dmn_metrics_count{id=test}[1m])))");
    }

    @Test
    public void testNumberTypeTypeRender() {
        NumberType numberType = new NumberType();
        String result = numberType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(number_dmn_metrics_sum{id=test}[1m])))/(sum(increase(number_dmn_metrics_count{id=test}[1m])))");
    }

    @Test
    public void testTimeAndDateTypeRender() {
        TimeAndDateType timeAndDateType = new TimeAndDateType();
        String result = timeAndDateType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(date_and_time_dmn_metrics_sum{id=test}[1m])))/(sum(increase(date_and_time_dmn_metrics_count{id=test}[1m])))");
    }

    @Test
    public void testYearsAndMonthsDurationTypeTypeRender() {
        YearsAndMonthsDurationType yearsAndMonthsDurationType = new YearsAndMonthsDurationType();
        String result = yearsAndMonthsDurationType.getGrafanaFunction().render("dmn_metrics", Collections.singletonList(new Label("id", "test")));
        Assertions.assertThat((String)result).isEqualTo("(sum(increase(years_and_months_duration_dmn_metrics_sum{id=test}[1m])))/(sum(increase(years_and_months_duration_dmn_metrics_count{id=test}[1m])))");
    }
}

