/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.utils;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.utils.GrafanaDashboardUtils;

class GrafanaDashboardUtilsTest {
    GrafanaDashboardUtilsTest() {
    }

    @Test
    void isOperationDashboardEnabled() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello")).isTrue();
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", "");
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello")).isTrue();
        String values = "Hello";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
        values = "Hello,Loan";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Traffic")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan")).isFalse();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
        values = " Hello, Loan ";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Traffic")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan")).isFalse();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
    }

    @Test
    void isDomainDashboardEnabled() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello")).isTrue();
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", "");
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello")).isTrue();
        String values = "Hello";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
        values = "Hello,Loan";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Traffic")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan")).isFalse();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
        values = " Hello, Loan ";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Traffic")).isTrue();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan")).isFalse();
        Assertions.assertThat((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello")).isFalse();
    }
}

