/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.JGrafana;
import org.kie.kogito.grafana.model.panel.GrafanaPanel;
import org.kie.kogito.grafana.model.panel.PanelType;
import org.kie.kogito.grafana.model.panel.common.YAxis;
import org.kie.kogito.grafana.model.panel.graph.GraphPanel;

public class JGrafanaTest {
    public static String readStandardDashboard() {
        InputStream is = JGrafanaTest.class.getResourceAsStream("/org/kie/kogito/grafana/test_dashboard.json");
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }

    @Test
    public void givenANewContextWhenANewJGrafanaObjectIsCreatedThenTheDefaultObjectIsCreated() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        Assertions.assertEquals((int)0, (int)grafanaObj.getDashboard().panels.size());
    }

    @Test
    public void givenANewContextWhenANewGraphPanelsAreAddedThenThePanelsAreInTheCorrectPositions() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 2", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 3", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 4", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 5", "api_http_response_code{handler=\"world\"}");
        Assertions.assertEquals((int)0, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)0)).gridPos.x);
        Assertions.assertEquals((int)0, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)0)).gridPos.y);
        Assertions.assertEquals((int)12, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)1)).gridPos.x);
        Assertions.assertEquals((int)0, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)1)).gridPos.y);
        Assertions.assertEquals((int)0, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)2)).gridPos.x);
        Assertions.assertEquals((int)8, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)2)).gridPos.y);
        Assertions.assertEquals((int)12, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)3)).gridPos.x);
        Assertions.assertEquals((int)8, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)3)).gridPos.y);
        Assertions.assertEquals((int)0, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)4)).gridPos.x);
        Assertions.assertEquals((int)16, (int)((GrafanaPanel)grafanaObj.getDashboard().panels.get((int)4)).gridPos.y);
    }

    @Test
    public void givenADashboardWhenAPanelIsDeletedThenTheDashboardIsCorrect() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}");
        grafanaObj.removePanelByTitle("My Graph 1");
        Assertions.assertEquals((int)0, (int)grafanaObj.getDashboard().panels.size());
    }

    @Test
    public void givenADashboardWithManyPanelsWhenAPanelIsDeletedThenTheDashboardIsCorrect() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 2", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 3", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 4", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 5", "api_http_response_code{handler=\"world\"}");
        grafanaObj.removePanelByTitle("My Graph 3");
        grafanaObj.removePanelByTitle("My Graph 5");
        Assertions.assertEquals((int)3, (int)grafanaObj.getDashboard().panels.size());
        Assertions.assertEquals((Object)true, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 1"));
        Assertions.assertEquals((Object)true, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 2"));
        Assertions.assertEquals((Object)true, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 4"));
        Assertions.assertEquals((Object)false, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 3"));
    }

    @Test
    public void givenADashboardWithManyPanelsWithSameTitleWhenAPanelIsDeletedThenAllThePanelsWithThatNameAreRemoved() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.HEATMAP, "My Graph 2", "sum(increase(api_execution_elapsed_nanosecond_bucket{handler=\"hello\"}[1m])) by (le)");
        grafanaObj.addPanel(PanelType.STAT, "My Graph 2", "sum(api_http_stacktrace_exceptions)");
        grafanaObj.addPanel(PanelType.TABLE, "My Graph 2", "api_http_stacktrace_exceptions");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 3", "api_http_response_code{handler=\"world\"}", null);
        grafanaObj.removePanelByTitle("My Graph 2");
        Assertions.assertEquals((int)2, (int)grafanaObj.getDashboard().panels.size());
        Assertions.assertEquals((Object)true, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 1"));
        Assertions.assertEquals((Object)false, (Object)grafanaObj.getDashboard().panels.stream().anyMatch(x -> x.title == "My Graph 2"));
    }

    @Test
    public void givenADashboardWithSomePanelsWhenAnUnexistingPanelIsLookedUpThenAnExceptionIsRaised() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}");
        grafanaObj.addPanel(PanelType.HEATMAP, "My Graph 2", "sum(increase(api_execution_elapsed_nanosecond_bucket{handler=\"hello\"}[1m])) by (le)");
        Assertions.assertThrows(NoSuchElementException.class, () -> grafanaObj.getPanelByTitle("Hello"));
    }

    @Test
    public void givenAYAxesObjectWhenAPanelIsAddedThenTheYAxesIsSet() {
        JGrafana grafanaObj = new JGrafana("My Dashboard");
        ArrayList<YAxis> yaxes = new ArrayList<YAxis>();
        yaxes.add(new YAxis("ms", true));
        yaxes.add(new YAxis("sc", false));
        grafanaObj.addPanel(PanelType.GRAPH, "My Graph 1", "api_http_response_code{handler=\"world\"}", yaxes);
        Assertions.assertEquals((int)2, (int)((GraphPanel)grafanaObj.getPanelByTitle((String)"My Graph 1")).yaxes.size());
    }

    @Test
    public void givenAnExistingDashboardWhenParseMethodIsCalledThenTheDashboardIsImported() {
        Assertions.assertDoesNotThrow(() -> {
            JGrafana dash = JGrafana.parse((String)JGrafanaTest.readStandardDashboard());
        });
    }
}

