/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.travels.ApprovalsModel;
import org.acme.travels.ApprovalsModelInput;
import org.acme.travels.ApprovalsModelOutput;
import org.acme.travels.Approvals_1_TaskModel;
import org.acme.travels.Approvals_1_TaskOutput;
import org.acme.travels.Approvals_2_TaskModel;
import org.acme.travels.Approvals_2_TaskOutput;
import org.acme.travels.Approvals_TaskModelFactory;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/approvals"})
@Component
public class ApprovalsResource {
    @Autowired
    @Qualifier(value="approvals")
    Process<ApprovalsModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> createResource_approvals(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull ApprovalsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new ApprovalsModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((ApprovalsModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    public List<ApprovalsModelOutput> getResources_approvals() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ApprovalsModelOutput getResource_approvals(@PathVariable(value="id") String id) {
        return (ApprovalsModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ApprovalsModelOutput deleteResource_approvals(@PathVariable(value="id") String id) {
        return (ApprovalsModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ApprovalsModelOutput updateModel_approvals(@PathVariable(value="id") String id, @RequestBody(required=false) ApprovalsModel resource) {
        return (ApprovalsModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public List<TaskModel> getTasks_approvals(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(Approvals_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ApprovalsModelOutput completeTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (ApprovalsModelOutput)this.processService.completeTask(this.process, id, taskId, phase, user, groups, (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}"}, consumes={"application/json"})
    public Approvals_1_TaskOutput saveTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (Approvals_1_TaskOutput)this.processService.saveTask(this.process, id, taskId, user, groups, (MapOutput)model, Approvals_1_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ApprovalsModelOutput taskTransition_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (ApprovalsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, user, groups, (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"})
    public Approvals_1_TaskModel getTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Approvals_1_TaskModel)this.processService.getTask(this.process, id, taskId, user, groups, Approvals_1_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"})
    public ApprovalsModelOutput abortTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ApprovalsModelOutput)this.processService.abortTask(this.process, id, taskId, phase, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"firstLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_firstLineApproval_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"firstLineApproval");
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "firstLineApproval", user, groups);
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, user, groups, commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/firstLineApproval/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, user, groups, comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, user, groups).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, user, groups, attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, user, groups, attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, user, groups).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ApprovalsModelOutput completeTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (ApprovalsModelOutput)this.processService.completeTask(this.process, id, taskId, phase, user, groups, (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}"}, consumes={"application/json"})
    public Approvals_2_TaskOutput saveTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (Approvals_2_TaskOutput)this.processService.saveTask(this.process, id, taskId, user, groups, (MapOutput)model, Approvals_2_TaskOutput::fromMap).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ApprovalsModelOutput taskTransition_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (ApprovalsModelOutput)this.processService.taskTransition(this.process, id, taskId, phase, user, groups, (MapOutput)model).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"})
    public Approvals_2_TaskModel getTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Approvals_2_TaskModel)this.processService.getTask(this.process, id, taskId, user, groups, Approvals_2_TaskModel::from).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"})
    public ApprovalsModelOutput abortTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ApprovalsModelOutput)this.processService.abortTask(this.process, id, taskId, phase, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"secondLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_secondLineApproval_1() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"secondLineApproval");
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.getSchemaAndPhases(this.process, id, taskId, "secondLineApproval", user, groups);
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addComment(this.process, id, taskId, user, groups, commentInfo).map(comment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/secondLineApproval/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId().toString()}).toUri()).body(comment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public Comment updateComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (Comment)this.processService.updateComment(this.process, id, taskId, commentId, user, groups, comment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteComment(this.process, id, taskId, commentId, user, groups).map(removed -> removed != false ? ResponseEntity.ok().build() : ResponseEntity.notFound().build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return this.processService.addAttachment(this.process, id, taskId, user, groups, attachmentInfo).map(attachment -> ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body(attachment)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public Attachment updateAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (Attachment)this.processService.updateAttachment(this.process, id, taskId, attachmentId, user, groups, attachment).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.processService.deleteAttachment(this.process, id, taskId, attachmentId, user, groups).map(removed -> (removed != false ? ResponseEntity.ok() : ResponseEntity.notFound()).build()).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public Attachment getAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Attachment)this.processService.getAttachment(this.process, id, taskId, attachmentId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Attachment " + attachmentId + " not found"));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/attachments"}, produces={"application/json"})
    public Collection<Attachment> getAttachments_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        return (Collection)this.processService.getAttachments(this.process, id, taskId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public Comment getComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Comment)this.processService.getComment(this.process, id, taskId, commentId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comment " + commentId + " not found"));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/comments"}, produces={"application/json"})
    public Collection<Comment> getComments_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (Collection)this.processService.getComments(this.process, id, taskId, user, groups).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

