/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.app.AddressMessageMarshaller;
import org.kie.kogito.app.TravellerMessageMarshaller;
import org.kie.kogito.persistence.BooleanProtostreamBaseMarshaller;
import org.kie.kogito.persistence.DateProtostreamBaseMarshaller;
import org.kie.kogito.persistence.DoubleProtostreamBaseMarshaller;
import org.kie.kogito.persistence.FloatProtostreamBaseMarshaller;
import org.kie.kogito.persistence.InstantProtostreamBaseMarshaller;
import org.kie.kogito.persistence.IntegerProtostreamBaseMarshaller;
import org.kie.kogito.persistence.LongProtostreamBaseMarshaller;
import org.kie.kogito.persistence.SerializableProtostreamBaseMarshaller;
import org.kie.kogito.persistence.StringProtostreamBaseMarshaller;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtostreamObjectMarshaller
implements ObjectMarshallerStrategy {
    private static final String NAMESPACE = "org.kie.kogito/";
    private SerializationContext context = new SerializationContextImpl(Configuration.builder().build());

    public ProtostreamObjectMarshaller() {
        try {
            this.context.registerProtoFiles(new FileDescriptorSource().addProtoFile("kogito-types.proto", this.getClass().getClassLoader().getResourceAsStream("META-INF/kogito-types.proto")).addProtoFile("application-types.proto", this.getClass().getClassLoader().getResourceAsStream("META-INF/application-types.proto")));
            this.context.registerMarshaller((BaseMarshaller)new StringProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new BooleanProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new DateProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new DoubleProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new FloatProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new IntegerProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new LongProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new InstantProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new SerializableProtostreamBaseMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new AddressMessageMarshaller());
            this.context.registerMarshaller((BaseMarshaller)new TravellerMessageMarshaller());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Integer order() {
        return 2;
    }

    public boolean acceptForMarshalling(Object object) {
        return this.context.canMarshall(object.getClass());
    }

    public Any marshall(Object object) {
        try {
            String string = this.context.getMarshaller(object.getClass()).getTypeName();
            return Any.newBuilder().setTypeUrl(NAMESPACE + string).setValue(ByteString.copyFrom((byte[])ProtobufUtil.toByteArray((ImmutableSerializationContext)this.context, (Object)object))).build();
        }
        catch (IOException iOException) {
            throw new ProcessInstanceMarshallerException("cannot marshall protobuf stream", (Throwable)iOException);
        }
    }

    public boolean acceptForUnmarshalling(Any any) {
        return any.getTypeUrl().startsWith(NAMESPACE);
    }

    public Object unmarshall(Any any) {
        try {
            String string = this.context.getMarshaller(this.removeNamespace(any.getTypeUrl())).getJavaClass().getCanonicalName();
            byte[] byArray = any.getValue().toByteArray();
            return ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.context, (byte[])byArray, (int)0, (int)byArray.length, Class.forName(string));
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new ProcessInstanceMarshallerException("cannot unmarshall protobuf stream", (Throwable)exception);
        }
    }

    private String removeNamespace(String string) {
        return string.substring(NAMESPACE.length());
    }
}

