/*
 * Decompiled with CFR 0.152.
 */
package org.drools.project.model;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.util.Drools;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.modelcompiler.KieBaseBuilder;
import org.drools.project.model.ProjectModel;
import org.kie.api.KieBase;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieRuntimeBuilder;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.springframework.stereotype.Component;

@Component
public class ProjectRuntime
implements KieRuntimeBuilder {
    private static final ProjectModel model = new ProjectModel();
    private static final Map<String, KieBase> kbases = ProjectRuntime.initKieBases();
    public static final ProjectRuntime INSTANCE = new ProjectRuntime();

    private static Map<String, KieBase> initKieBases() {
        ConcurrentHashMap<String, KieBase> kbaseMap = new ConcurrentHashMap<String, KieBase>();
        if (Drools.isNativeImage()) {
            kbaseMap.put("defaultKieBase", (KieBase)KieBaseBuilder.createKieBaseFromModel((Collection)model.getModelsForKieBase("defaultKieBase"), (KieBaseModel)((KieBaseModel)model.getKieModuleModel().getKieBaseModels().get("defaultKieBase"))));
        }
        return kbaseMap;
    }

    public KieBase getKieBase() {
        return this.getKieBase("defaultKieBase");
    }

    public KieBase getKieBase(String name) {
        return kbases.computeIfAbsent(name, n -> KieBaseBuilder.createKieBaseFromModel((Collection)model.getModelsForKieBase(n), (KieBaseModel)((KieBaseModel)model.getKieModuleModel().getKieBaseModels().get(n))));
    }

    public KieSession newKieSession() {
        return this.newKieSession("defaultKieSession");
    }

    public KieSession newKieSession(String sessionName) {
        KieBase kbase = this.getKieBaseForSession(sessionName);
        if (kbase == null) {
            throw new RuntimeException("Unknown KieSession with name '" + sessionName + "'");
        }
        KieSession ksession = kbase.newKieSession(this.getConfForSession(sessionName), null);
        return ksession;
    }

    private KieBase getKieBaseForSession(String sessionName) {
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                return this.getKieBase("defaultKieBase");
            }
            case "defaultKieSession": {
                return this.getKieBase("defaultKieBase");
            }
        }
        return null;
    }

    private KieSessionConfiguration getConfForSession(String sessionName) {
        SessionConfiguration conf = (SessionConfiguration)RuleBaseFactory.newKnowledgeSessionConfiguration().as(SessionConfiguration.KEY);
        switch (sessionName) {
            case "defaultStatelessKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
                break;
            }
            case "defaultKieSession": {
                conf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
            }
        }
        return conf;
    }
}

