/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.jobs;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.test.resources.CompositeTestResource;
import org.kie.kogito.testcontainers.JobServiceContainer;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class JobServiceLeaderIT {
    private static CompositeTestResource resource;
    private static final Logger logger;
    private static List<JobServiceContainer> containers;

    @BeforeAll
    public static void init() {
        KogitoPostgreSqlContainer postgreSqlContainer = new KogitoPostgreSqlContainer();
        resource = new CompositeTestResource((KogitoGenericContainer)new JobServiceContainer()).withServiceContainer("job-service-1", (KogitoGenericContainer)new JobServiceContainer(), new GenericContainer[]{postgreSqlContainer}).withServiceContainer("job-service-2", (KogitoGenericContainer)new JobServiceContainer(), new GenericContainer[]{postgreSqlContainer}).withDependencyToService("main-service", new GenericContainer[]{postgreSqlContainer});
        containers = resource.getServiceContainers(JobServiceContainer.class);
        containers.forEach(c -> c.withEnv("KOGITO_JOBS_SERVICE_MANAGEMENT_HEARTBEAT_EXPIRATION_IN_SECONDS", "2"));
        resource.start();
    }

    @Test
    public void testSingleLeader() {
        List responses = containers.stream().map(container -> JobServiceLeaderIT.healthRequest(container)).collect(Collectors.toList());
        Assertions.assertThat(responses).containsExactlyInAnyOrder((Object[])new Integer[]{200, 503, 503});
    }

    @Test
    public void testChangingLeader() {
        JobServiceContainer leader = containers.stream().filter(container -> 200 == JobServiceLeaderIT.healthRequest(container)).findFirst().orElse(null);
        leader.stop();
        List remain = containers.stream().filter(container -> container.isRunning()).collect(Collectors.toList());
        Assertions.assertThat(remain).hasSize(2);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            List responses = remain.stream().map(container -> JobServiceLeaderIT.healthRequest(container)).collect(Collectors.toList());
            Assertions.assertThat(responses).containsExactlyInAnyOrder((Object[])new Integer[]{200, 503});
        });
        leader.start();
        Assertions.assertThat((int)JobServiceLeaderIT.healthRequest(leader)).isEqualTo(503);
    }

    private static int healthRequest(JobServiceContainer container) {
        String url = "http://" + container.getHost() + ":" + container.getMappedPort();
        logger.debug("Request to URL " + url);
        return ((Response)RestAssured.given().baseUri(url).contentType(ContentType.JSON).accept(ContentType.JSON).when().get("/q/health/ready", new Object[0])).statusCode();
    }

    static {
        logger = LoggerFactory.getLogger(JobServiceLeaderIT.class);
    }
}

