/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.jobs;

import io.restassured.path.json.JsonPath;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.kie.kogito.it.jobs.BaseSwitchStateTimeoutsIT;
import org.kie.kogito.test.TestUtils;
import org.kie.kogito.test.quarkus.kafka.KafkaTestClient;

public class KafkaBaseSwitchStateTimeoutsIT
extends BaseSwitchStateTimeoutsIT {
    private KafkaTestClient kafkaClient;
    private static final String KOGITO_OUTGOING_STREAM_TOPIC = "kogito-sw-out-events";

    @BeforeEach
    void setup() {
        String kafkaBootstrapServers = (String)ConfigProvider.getConfig().getValue("kafka.bootstrap.servers", String.class);
        this.kafkaClient = new KafkaTestClient(kafkaBootstrapServers);
    }

    @AfterEach
    void cleanUp() {
        this.kafkaClient.shutdown();
    }

    @Override
    protected void verifyNoDecisionEventWasProduced(String processInstanceId) throws Exception {
        JsonPath result = TestUtils.waitForEvent((KafkaTestClient)this.kafkaClient, (String)KOGITO_OUTGOING_STREAM_TOPIC, (long)50L);
        KafkaBaseSwitchStateTimeoutsIT.assertDecisionEvent(result, processInstanceId, "process_result_event", "NoDecision");
    }
}

