/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.travels.AsyncModel;
import org.acme.travels.AsyncModelInput;
import org.acme.travels.AsyncModelOutput;
import org.acme.travels.Async_TaskModelFactory;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.workitem.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/async"})
@Component
public class AsyncResource {
    @Autowired
    @Qualifier(value="async")
    Process<AsyncModel> process;
    @Autowired
    ProcessService processService;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<AsyncModelOutput> createResource_async(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull AsyncModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        ProcessInstance pi = this.processService.createProcessInstance(this.process, businessKey, (Model)Optional.ofNullable(resource).orElse(new AsyncModelInput()).toModel(), (String)httpHeaders.getOrEmpty((Object)"X-KOGITO-StartFromNode").stream().findFirst().orElse(null));
        return ResponseEntity.created((URI)uriComponentsBuilder.path("/async/{id}").buildAndExpand(new Object[]{pi.id()}).toUri()).body((Object)((AsyncModel)pi.checkError().variables()).toModel());
    }

    @GetMapping(produces={"application/json"})
    public List<AsyncModelOutput> getResources_async() {
        return this.processService.getProcessInstanceOutput(this.process);
    }

    @GetMapping(value={"/schema"}, produces={"application/json"})
    public Map<String, Object> getResourceSchema_async() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public AsyncModelOutput getResource_async(@PathVariable(value="id") String id) {
        return (AsyncModelOutput)this.processService.findById(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public AsyncModelOutput deleteResource_async(@PathVariable(value="id") String id) {
        return (AsyncModelOutput)this.processService.delete(this.process, id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public AsyncModelOutput updateModel_async(@PathVariable(value="id") String id, @RequestBody(required=false) AsyncModel resource) {
        return (AsyncModelOutput)this.processService.update(this.process, id, (MappableToModel)resource).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public List<TaskModel> getTasks_async(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return ((List)this.processService.getTasks(this.process, id, SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)user, groups))).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND))).stream().map(Async_TaskModelFactory::from).collect(Collectors.toList());
    }

    @PostMapping(value={"/{id}/complete"}, produces={"application/json"}, consumes={"application/json"})
    public AsyncModelOutput signal_0(@PathVariable(value="id") String id) {
        return (AsyncModelOutput)this.processService.signalProcessInstance(this.process, id, null, "complete").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

    @PostMapping(value={"/{id}/bye"}, produces={"application/json"}, consumes={"application/json"})
    public AsyncModelOutput signal_1(@PathVariable(value="id") String id) {
        return (AsyncModelOutput)this.processService.signalProcessInstance(this.process, id, null, "bye").orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }
}

