/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Person;

public abstract class PersistenceTest {
    public static final String PROCESS_ID = "hello";
    public static String PROCESS_EMBEDDED_ID = "embedded";

    @Test
    void testPersistence() {
        Person person = new Person("Name", 10);
        String pid = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(Map.of("var1", "Tiago", "person", person)).post("/{processId}", new Object[]{PROCESS_ID})).then()).statusCode(201)).header("Location", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()))).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("var1", CoreMatchers.equalTo((Object)"Tiago"), new Object[0])).body("var2", CoreMatchers.equalTo((Object)"Hello Tiago! Script"), new Object[0])).body("person.name", CoreMatchers.equalTo((Object)person.getName()), new Object[0])).body("person.age", CoreMatchers.equalTo((Object)person.getAge()), new Object[0])).extract().path("id", new String[0]);
        String createdPid = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/{processId}/{id}", new Object[]{PROCESS_ID, pid})).then()).statusCode(200)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("var1", CoreMatchers.equalTo((Object)"Tiago"), new Object[0])).body("var2", CoreMatchers.equalTo((Object)"Hello Tiago! Script"), new Object[0])).body("person.name", CoreMatchers.equalTo((Object)person.getName()), new Object[0])).body("person.age", CoreMatchers.equalTo((Object)person.getAge()), new Object[0])).extract().path("id", new String[0]);
        Assertions.assertEquals((Object)createdPid, (Object)pid);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().delete("/management/processes/{processId}/instances/{processInstanceId}", new Object[]{PROCESS_ID, pid})).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/greetings/{id}", new Object[]{pid})).then()).statusCode(404);
    }

    @Test
    void testHealthCheck() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/q/health", new Object[0])).then()).statusCode(200)).body("status", CoreMatchers.equalTo((Object)"UP"), new Object[0]);
    }

    @Test
    void testEmbeddedProcess() {
        String pId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).when().post("/{processId}", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).extract().path("id", new String[0]);
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("user", new Object[]{"admin"}).queryParam("group", new Object[]{"managers"}).pathParam("pId", (Object)pId).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).when().get("/{processId}/{pId}/tasks", new Object[0])).then()).statusCode(200)).extract().path("[0].id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("pId", (Object)pId).pathParam("taskId", (Object)taskId).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).body("{}").when().post("/{processId}/{pId}/Task/{taskId}/phases/complete", new Object[0])).then()).statusCode(200);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

