/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Address;
import org.kie.kogito.Person;

public abstract class PersistenceTest {
    public static final Duration TIMEOUT = Duration.ofSeconds(10L);
    public static final String PROCESS_ID = "hello";
    public static final String PROCESS_EMBEDDED_ID = "embedded";
    public static final String PROCESS_MULTIPLE_INSTANCES_EMBEDDED_ID = "MultipleInstanceEmbeddedSubProcess";
    public static final String PROCESS_MULTIPLE_INSTANCES_ID = "MultipleInstanceSubProcess";
    public static final String PROCESS_ASYNC_WIH = "AsyncWIH";

    @Test
    void testPersistence() {
        Person person = new Person("Name", 10, BigDecimal.valueOf(5.0), Instant.now().truncatedTo(ChronoUnit.MILLIS), ZonedDateTime.now(ZoneOffset.UTC));
        Person relative = new Person("relative", 5, BigDecimal.valueOf(5.0), Instant.now().truncatedTo(ChronoUnit.MILLIS), ZonedDateTime.now(ZoneOffset.UTC));
        person.setRelatives(new Person[]{relative});
        person.setAddresses(Arrays.asList(new Address("Brisbane"), new Address("Sydney")));
        String pid = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(Map.of("var1", "Tiago", "person", person)).post("/{processId}", new Object[]{PROCESS_ID})).then()).statusCode(201)).header("Location", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()))).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("var1", CoreMatchers.equalTo((Object)"Tiago"), new Object[0])).body("var2", CoreMatchers.equalTo((Object)"Hello Tiago! Script"), new Object[0])).body("person.name", CoreMatchers.equalTo((Object)person.getName()), new Object[0])).body("person.age", CoreMatchers.equalTo((Object)person.getAge()), new Object[0])).body("person.score", CoreMatchers.equalTo((Object)Float.valueOf(person.getScore().floatValue())), new Object[0])).body("person.created", CoreMatchers.equalTo((Object)DateTimeFormatter.ISO_INSTANT.format(person.getCreated())), new Object[0])).body("person.updated", CoreMatchers.equalTo((Object)person.getUpdated().format(DateTimeFormatter.ISO_ZONED_DATE_TIME)), new Object[0])).body("person.relatives.size()", CoreMatchers.equalTo((Object)1), new Object[0])).body("person.relatives[0].name", CoreMatchers.equalTo((Object)relative.getName()), new Object[0])).body("person.relatives[0].age", CoreMatchers.equalTo((Object)relative.getAge()), new Object[0])).body("person.addresses.size()", CoreMatchers.equalTo((Object)person.getAddresses().size()), new Object[0])).body("person.addresses[0].city", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(0)).getCity()), new Object[0])).body("person.addresses[1].city", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getCity()), new Object[0])).body("person.addresses[1].type", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getType().name()), new Object[0])).body("person.addresses[1].status", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getStatus().name()), new Object[0])).extract().path("id", new String[0]);
        String createdPid = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/{processId}/{id}", new Object[]{PROCESS_ID, pid})).then()).statusCode(200)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).body("var1", CoreMatchers.equalTo((Object)"Tiago"), new Object[0])).body("var2", CoreMatchers.equalTo((Object)"Hello Tiago! Script"), new Object[0])).body("person.name", CoreMatchers.equalTo((Object)person.getName()), new Object[0])).body("person.age", CoreMatchers.equalTo((Object)person.getAge()), new Object[0])).body("person.score", CoreMatchers.equalTo((Object)Float.valueOf(person.getScore().floatValue())), new Object[0])).body("person.created", CoreMatchers.equalTo((Object)DateTimeFormatter.ISO_INSTANT.format(person.getCreated().truncatedTo(ChronoUnit.MILLIS))), new Object[0])).body("person.updated", CoreMatchers.equalTo((Object)person.getUpdated().format(DateTimeFormatter.ISO_ZONED_DATE_TIME)), new Object[0])).body("person.relatives.size()", CoreMatchers.equalTo((Object)1), new Object[0])).body("person.relatives[0].name", CoreMatchers.equalTo((Object)relative.getName()), new Object[0])).body("person.relatives[0].age", CoreMatchers.equalTo((Object)relative.getAge()), new Object[0])).body("person.addresses.size()", CoreMatchers.equalTo((Object)person.getAddresses().size()), new Object[0])).body("person.addresses[0].city", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(0)).getCity()), new Object[0])).body("person.addresses[1].city", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getCity()), new Object[0])).body("person.addresses[1].type", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getType().name()), new Object[0])).body("person.addresses[1].status", CoreMatchers.equalTo((Object)((Address)person.getAddresses().get(1)).getStatus().name()), new Object[0])).extract().path("id", new String[0]);
        Assertions.assertEquals((Object)createdPid, (Object)pid);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/greetings/{id}", new Object[]{pid})).then()).statusCode(404);
    }

    @Test
    void testHealthCheck() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/q/health", new Object[0])).then()).statusCode(200)).body("status", CoreMatchers.equalTo((Object)"UP"), new Object[0]);
    }

    @Test
    void testEmbeddedProcess() {
        String pId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).when().post("/{processId}", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).extract().path("id", new String[0]);
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("user", new Object[]{"admin"}).queryParam("group", new Object[]{"managers"}).pathParam("pId", (Object)pId).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).when().get("/{processId}/{pId}/tasks", new Object[0])).then()).statusCode(200)).extract().path("[0].id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("pId", (Object)pId).pathParam("taskId", (Object)taskId).pathParam("processId", (Object)PROCESS_EMBEDDED_ID).queryParam("user", new Object[]{"test"}).queryParam("group", new Object[]{"test"}).body("{}").when().post("/{processId}/{pId}/Task/{taskId}/phases/complete", new Object[0])).then()).statusCode(200);
    }

    @Test
    void testMultipleEmbeddedInstance() {
        String pId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_EMBEDDED_ID).when().post("/{processId}", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).extract().path("id", new String[0]);
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).queryParam("user", new Object[]{"admin"}).pathParam("pId", (Object)pId).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_EMBEDDED_ID).when().get("/{processId}/{pId}/tasks", new Object[0])).then()).statusCode(200)).extract().path("[0].id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("pId", (Object)pId).pathParam("taskId", (Object)taskId).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_EMBEDDED_ID).queryParam("user", new Object[]{"admin"}).queryParam("group", new Object[]{"admin"}).body("{}").when().post("/{processId}/{pId}/Task/{taskId}/phases/complete", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_EMBEDDED_ID).pathParam("pId", (Object)pId).when().get("/{processId}/{pId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    void testMultipleInstance() {
        String pId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_ID).when().post("/{processId}", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_MULTIPLE_INSTANCES_ID).pathParam("pId", (Object)pId).when().get("/{processId}/{pId}", new Object[0])).then()).statusCode(404);
    }

    @Test
    void testAsyncWIH() {
        String pId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_ASYNC_WIH).when().post("/{processId}", new Object[0])).then()).statusCode(201)).body("id", CoreMatchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0])).extract().path("id", new String[0]);
        Awaitility.await().atMost(TIMEOUT).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).pathParam("processId", (Object)PROCESS_ASYNC_WIH).pathParam("pId", (Object)pId).when().get("/{processId}/{pId}", new Object[0])).then()).statusCode(404));
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

