/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.kie.kogito.Address;
import org.kie.kogito.Status;

public class Person
implements Serializable {
    private String id = UUID.randomUUID().toString();
    private String name;
    private int age;
    private boolean adult;
    private Person parent;
    private Instant created;
    private ZonedDateTime updated;
    private BigDecimal score;
    private Person[] relatives;
    private Status status = Status.ACTIVE;
    private transient String ignoreMe;
    private static String staticallyIgnoreMe;
    private List<Address> addresses;

    public Person() {
    }

    public Person(String name, int age, BigDecimal score, Instant created, ZonedDateTime updated) {
        this();
        this.name = name;
        this.age = age;
        this.score = score;
        this.created = created;
        this.updated = updated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean isAdult() {
        return this.adult;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }

    public String getIgnoreMe() {
        return this.ignoreMe;
    }

    public void setIgnoreMe(String ignoreMe) {
        this.ignoreMe = ignoreMe;
    }

    public static String getStaticallyIgnoreMe() {
        return staticallyIgnoreMe;
    }

    public static void setStaticallyIgnoreMe(String staticallyIgnoreMe) {
        Person.staticallyIgnoreMe = staticallyIgnoreMe;
    }

    public void addAddress(Address address) {
        this.addresses.add(address);
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Person getParent() {
        return this.parent;
    }

    public void setParent(Person parent) {
        this.parent = parent;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(ZonedDateTime updated) {
        this.updated = updated;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public Person[] getRelatives() {
        return this.relatives;
    }

    public void setRelatives(Person[] relatives) {
        this.relatives = relatives;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "Person{id='" + this.id + "', name='" + this.name + "', age=" + this.age + ", adult=" + this.adult + ", parent=" + this.parent + ", created=" + this.created + ", updated=" + this.updated + ", score=" + this.score + ", relatives=" + Arrays.toString(this.relatives) + ", status=" + this.status + ", ignoreMe='" + this.ignoreMe + "', addresses=" + this.addresses + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return this.id.equals(person.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

