/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests.quarkus;

import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.integrationtests.quarkus.HospitalsTestData;
import org.kie.kogito.integrationtests.quarkus.Patient;

@QuarkusIntegrationTest
public class HospitalsIT {
    @Test
    public void testCovidPositive() {
        HospitalsTestData data = new HospitalsTestData();
        data.setPatient(new Patient(){
            {
                this.setCovidPositive(true);
                this.setDiagnosis("tumor");
            }
        });
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/Hospitals", new Object[0])).then()).statusCode(200)).body("'Suitable Hospitals'", Matchers.equalTo(Collections.singletonList("Military Hospital")), new Object[0]);
    }

    @Test
    public void testTumor() {
        HospitalsTestData data = new HospitalsTestData();
        data.setPatient(new Patient(){
            {
                this.setCovidPositive(false);
                this.setDiagnosis("tumor");
            }
        });
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/Hospitals", new Object[0])).then()).statusCode(200)).body("'Suitable Hospitals'", Matchers.equalTo(Collections.singletonList("National Hospital")), new Object[0]);
    }

    @Test
    public void testBrokenLeg() {
        HospitalsTestData data = new HospitalsTestData();
        data.setPatient(new Patient(){
            {
                this.setCovidPositive(false);
                this.setDiagnosis("broken leg");
            }
        });
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/Hospitals", new Object[0])).then()).statusCode(200)).body("'Suitable Hospitals'", Matchers.equalTo(Arrays.asList("National Hospital", "Private Hospital", "University Hospital")), new Object[0]);
    }

    @Test
    public void testDiabetes() {
        HospitalsTestData data = new HospitalsTestData();
        data.setPatient(new Patient(){
            {
                this.setCovidPositive(false);
                this.setDiagnosis("diabetes");
            }
        });
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body((Object)data).contentType(ContentType.JSON).when().post("/Hospitals", new Object[0])).then()).statusCode(200)).body("'Suitable Hospitals'", Matchers.equalTo(Arrays.asList("National Hospital", "University Hospital")), new Object[0]);
    }
}

