/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.kie.kogito.queries.Applicant;
import org.kie.kogito.queries.LoanApplication;
import org.kie.kogito.queries.LoanUnit;

public class DecisionTableIT {
    private static final String PACKAGE = "org.kie.kogito.queries";
    private static final String RESOURCE_FILE = "src/main/resources/" + "org.kie.kogito.queries".replace('.', '/') + "/LoanUnit.xls";
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("LoanUnit.xls.test", RESOURCE_FILE)).addAsResource("LoanUnit.xls.properties.test", RESOURCE_FILE + ".properties")).addClasses(new Class[]{Applicant.class, LoanApplication.class, LoanUnit.class}));
    private static final String JSON_PAYLOAD = "{\n  \"maxAmount\":5000,\n  \"loanApplications\":[\n    {\n      \"id\":\"ABC10001\",\n      \"amount\":2000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":45,\n        \"name\":\"John\"\n      }\n    },\n    {\n      \"id\":\"ABC10002\",\n      \"amount\":5000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":25,\n        \"name\":\"Paul\"\n      }\n    },\n    {\n      \"id\":\"ABC10015\",\n      \"amount\":1000,\n      \"deposit\":100,\n      \"applicant\":{\n        \"age\":12,\n        \"name\":\"George\"\n      }\n    }\n  ]\n}";

    @Test
    public void testApproved() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(JSON_PAYLOAD).contentType(ContentType.JSON).when().post("/find-approved", new Object[0])).then()).statusCode(200)).body("id", Matchers.hasItem((Object)"ABC10001"), new Object[0]);
    }

    @Test
    public void testNotApproved() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(JSON_PAYLOAD).contentType(ContentType.JSON).when().post("/find-not-approved-id-and-amount", new Object[0])).then()).statusCode(200)).body("$id", Matchers.hasItems((Object[])new String[]{"ABC10002", "ABC10015"}), new Object[0]);
    }
}

