/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.signal.SignalManager;

public class LightWorkItemManager
implements org.drools.core.process.instance.WorkItemManager {
    private static final long serialVersionUID = 510L;
    private AtomicLong workItemCounter = new AtomicLong(0L);
    private Map<Long, org.drools.core.process.instance.WorkItem> workItems = new ConcurrentHashMap<Long, org.drools.core.process.instance.WorkItem>();
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;

    public LightWorkItemManager(ProcessInstanceManager processInstanceManager, SignalManager signalManager) {
        this.processInstanceManager = processInstanceManager;
        this.signalManager = signalManager;
    }

    public void internalExecuteWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        ((WorkItemImpl)workItem).setId(this.workItemCounter.incrementAndGet());
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
        }
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
    }

    public void internalAddWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
        if (workItem.getId() > this.workItemCounter.get()) {
            this.workItemCounter.set(workItem.getId());
        }
    }

    public void internalAbortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getId());
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
            handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)this);
            this.workItems.remove(workItem.getId());
        }
    }

    public WorkItemHandler getWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void retryWorkItem(long workItemId) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(long workItemId, Map<String, Object> map) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else {
                throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
            }
        }
    }

    public Set<org.drools.core.process.instance.WorkItem> getWorkItems() {
        return new HashSet<org.drools.core.process.instance.WorkItem>(this.workItems.values());
    }

    public org.drools.core.process.instance.WorkItem getWorkItem(long id) {
        return this.workItems.get(id);
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            workItem.setResults(results);
            ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
        } else {
            throw new WorkItemNotFoundException("Work Item (" + id + ") does not exist", Long.valueOf(id));
        }
        this.workItems.remove(id);
    }

    public void abortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            this.workItems.remove(id);
        }
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    public void retryWorkItem(Long workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }
}

