/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;
import org.kie.services.time.manager.TimerInstance;
import org.kie.services.time.manager.TimerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="update-timer-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class UpdateTimerCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -8252686458877022330L;
    private static final Logger logger = LoggerFactory.getLogger(UpdateTimerCommand.class);
    @XmlElement
    @XmlSchemaType(name="long")
    protected long processInstanceId;
    @XmlElement
    @XmlSchemaType(name="long")
    protected long timerId;
    @XmlElement
    @XmlSchemaType(name="string")
    protected String timerName;
    @XmlElement
    @XmlSchemaType(name="long")
    protected long delay;
    @XmlElement
    @XmlSchemaType(name="long")
    protected long period;
    @XmlElement
    @XmlSchemaType(name="int")
    protected int repeatLimit;

    public UpdateTimerCommand(long processInstanceId, String timerName, long delay) {
        this(processInstanceId, timerName, delay, 0L, 0);
    }

    public UpdateTimerCommand(long processInstanceId, String timerName, long period, int repeatLimit) {
        this(processInstanceId, timerName, 0L, period, repeatLimit);
    }

    public UpdateTimerCommand(long processInstanceId, String timerName, long delay, long period, int repeatLimit) {
        this.processInstanceId = processInstanceId;
        this.timerName = timerName;
        this.timerId = -1L;
        this.delay = delay;
        this.period = period;
        this.repeatLimit = repeatLimit;
    }

    public UpdateTimerCommand(long processInstanceId, long timerId, long delay) {
        this(processInstanceId, timerId, delay, 0L, 0);
    }

    public UpdateTimerCommand(long processInstanceId, long timerId, long period, int repeatLimit) {
        this(processInstanceId, timerId, 0L, period, repeatLimit);
    }

    public UpdateTimerCommand(long processInstanceId, long timerId, long delay, long period, int repeatLimit) {
        this.processInstanceId = processInstanceId;
        this.timerId = timerId;
        this.delay = delay;
        this.period = period;
        this.repeatLimit = repeatLimit;
    }

    public Void execute(Context context) {
        logger.debug("About to cancel timer in process instance {} by name '{}' or id {}", new Object[]{this.processInstanceId, this.timerName, this.timerId});
        KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        TimerManager tm = this.getTimerManager(kieSession);
        RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)kieSession.getProcessInstance(this.processInstanceId);
        if (wfp == null) {
            throw new IllegalArgumentException("Process instance with id " + this.processInstanceId + " not found");
        }
        for (NodeInstance nodeInstance : wfp.getNodeInstances(true)) {
            StateBasedNodeInstance sbni;
            List<Long> timerList;
            if (nodeInstance instanceof TimerNodeInstance) {
                TimerNodeInstance tni = (TimerNodeInstance)nodeInstance;
                if (tni.getTimerId() != this.timerId && (tni.getNodeName() == null || !tni.getNodeName().equals(this.timerName))) continue;
                TimerInstance timer = (TimerInstance)tm.getTimerMap().get(tni.getTimerId());
                TimerInstance newTimer = this.rescheduleTimer(timer, tm);
                logger.debug("New timer {} about to be registered", (Object)newTimer);
                tm.registerTimer(newTimer, (ProcessInstance)wfp);
                tni.internalSetTimerId(newTimer.getId());
                logger.debug("New timer {} successfully registered", (Object)newTimer);
                break;
            }
            if (!(nodeInstance instanceof StateBasedNodeInstance) || ((timerList = (sbni = (StateBasedNodeInstance)nodeInstance).getTimerInstances()) == null || !timerList.contains(this.timerId)) && (sbni.getNodeName() == null || !sbni.getNodeName().equals(this.timerName))) continue;
            if (timerList == null || timerList.size() != 1) break;
            TimerInstance timer = (TimerInstance)tm.getTimerMap().get(timerList.get(0));
            TimerInstance newTimer = this.rescheduleTimer(timer, tm);
            logger.debug("New timer {} about to be registered", (Object)newTimer);
            tm.registerTimer(newTimer, (ProcessInstance)wfp);
            timerList.clear();
            timerList.add(newTimer.getId());
            sbni.internalSetTimerInstances(timerList);
            logger.debug("New timer {} successfully registered", (Object)newTimer);
            break;
        }
        return null;
    }

    public void setProcessInstanceId(Long procInstId) {
        this.processInstanceId = procInstId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    protected TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }

    public String toString() {
        return "processInstance.updateTimer(" + this.timerName + ", " + this.delay + ", " + this.period + ", " + this.repeatLimit + ");";
    }

    protected long calculateDelay(long delay, TimerInstance timer) {
        long diff = System.currentTimeMillis() - timer.getActivated().getTime();
        return delay * 1000L - diff;
    }

    protected TimerInstance rescheduleTimer(TimerInstance timer, TimerManager tm) {
        logger.debug("Found timer {} that is going to be canceled", (Object)timer);
        tm.cancelTimer(timer.getTimerId());
        logger.debug("Timer {} canceled successfully", (Object)timer);
        TimerInstance newTimer = new TimerInstance();
        if (this.delay != 0L) {
            newTimer.setDelay(this.calculateDelay(this.delay, timer));
        }
        newTimer.setPeriod(this.period);
        newTimer.setRepeatLimit(this.repeatLimit);
        newTimer.setTimerId(timer.getTimerId());
        return newTimer;
    }
}

