/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.variable;

import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.variable.Variable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class VariableTest {
    private Variable tested;

    VariableTest() {
    }

    @BeforeEach
    public void setUp() {
        this.tested = new Variable();
    }

    @Test
    void testValidIdentifierName() {
        String name = "valid";
        this.tested.setName("valid");
        this.assertValidSanitizedName("valid");
        Assertions.assertThat((String)this.tested.getSanitizedName()).isEqualTo("valid");
    }

    private void assertValidSanitizedName(String name) {
        Assertions.assertThat((String)this.tested.getName()).isEqualTo(name);
        Assertions.assertThat((boolean)SourceVersion.isName(this.tested.getSanitizedName())).isTrue();
    }

    @Test
    void testInvalidIdentifierName() {
        String name = "123valid%^\u00e1+-)([]?!@";
        this.tested.setName("123valid%^\u00e1+-)([]?!@");
        this.assertValidSanitizedName("123valid%^\u00e1+-)([]?!@");
        ((AbstractStringAssert)Assertions.assertThat((String)this.tested.getSanitizedName()).isNotEqualTo((Object)"123valid%^\u00e1+-)([]?!@")).isEqualTo("valid");
    }

    @Test
    void testInvalidIdentifierWithReservedWordName() {
        String name = "123class%^\u00e1+-)([]?!@";
        this.tested.setName("123class%^\u00e1+-)([]?!@");
        this.assertValidSanitizedName("123class%^\u00e1+-)([]?!@");
        ((AbstractStringAssert)Assertions.assertThat((String)this.tested.getSanitizedName()).isNotEqualTo((Object)"123class%^\u00e1+-)([]?!@")).isEqualTo("v$class");
    }

    @Test
    void testReservedWordsName() {
        Stream.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while").forEach(name -> {
            this.tested.setName(name);
            this.assertValidSanitizedName((String)name);
            ((AbstractStringAssert)Assertions.assertThat((String)this.tested.getSanitizedName()).isNotEqualTo(name)).isEqualTo("v$" + this.tested.getName());
        });
    }
}

