/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.instance;

import org.assertj.core.api.Assertions;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.LoggerFactory;

public class RuleFlowProcessInstanceTest
extends AbstractBaseTest {
    private static String PROCESS_ID = "process.test";

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testStartProcessThrowException() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(PROCESS_ID);
        process.setName("test");
        process.setPackageName("org.mycomp.myprocess");
        KieSession workingMemory = this.createKieSession(new Process[]{process});
        Assertions.assertThatThrownBy(() -> workingMemory.startProcess(PROCESS_ID)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testStartProcessDynamic() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId(PROCESS_ID);
        process.setName("test");
        process.setPackageName("org.mycomp.myprocess");
        process.setDynamic(true);
        KieSession workingMemory = this.createKieSession(new Process[]{process});
        ProcessInstance instance = workingMemory.startProcess(PROCESS_ID);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

