/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.event;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.DataTransformer;

public class EventTransformerImpl
implements EventTransformer,
Serializable {
    private static final long serialVersionUID = 5861307291725051774L;
    private Transformation transformation;
    private String name;

    public EventTransformerImpl(Transformation transformation) {
        if (transformation != null) {
            this.transformation = transformation;
            this.name = transformation.getSource();
            if (this.name == null) {
                this.name = "event";
            }
        }
    }

    @Override
    public Object transformEvent(Object event) {
        if (event == null || this.transformation == null) {
            return event;
        }
        DataTransformer transformer = DataTransformerRegistry.get().find(this.transformation.getLanguage());
        if (transformer != null) {
            return transformer.transform(this.transformation.getCompiledExpression(), Optional.ofNullable(event).filter(Map.class::isInstance).map(Map.class::cast).orElseGet(() -> Collections.singletonMap(this.name, event)));
        }
        return event;
    }
}

