/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.Set;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.MappableNodeFactory;
import org.jbpm.ruleflow.core.factory.StateBasedNodeFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.WorkItemNode;

public class WorkItemNodeFactory
extends StateBasedNodeFactory
implements MappableNodeFactory {
    public static final String METHOD_WORK_NAME = "workName";
    public static final String METHOD_WORK_PARAMETER = "workParameter";

    public WorkItemNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
    }

    @Override
    protected Node createNode() {
        return new WorkItemNode();
    }

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    @Override
    public WorkItemNodeFactory name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public WorkItemNodeFactory onEntryAction(String dialect, String action) {
        super.onEntryAction(dialect, action);
        return this;
    }

    @Override
    public WorkItemNodeFactory onExitAction(String dialect, String action) {
        super.onExitAction(dialect, action);
        return this;
    }

    @Override
    public WorkItemNodeFactory timer(String delay, String period, String dialect, String action) {
        super.timer(delay, period, dialect, action);
        return this;
    }

    @Override
    public Mappable getMappableNode() {
        return this.getWorkItemNode();
    }

    @Override
    public WorkItemNodeFactory inMapping(String parameterName, String variableName) {
        MappableNodeFactory.super.inMapping(parameterName, variableName);
        return this;
    }

    @Override
    public WorkItemNodeFactory outMapping(String parameterName, String variableName) {
        MappableNodeFactory.super.outMapping(parameterName, variableName);
        return this;
    }

    public WorkItemNodeFactory waitForCompletion(boolean waitForCompletion) {
        this.getWorkItemNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public WorkItemNodeFactory workName(String name) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setName(name);
        return this;
    }

    public WorkItemNodeFactory workParameter(String name, Object value) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setParameter(name, value);
        return this;
    }

    public WorkItemNodeFactory workParameterDefinition(String name, DataType dataType) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        Set<ParameterDefinition> parameterDefinitions = work.getParameterDefinitions();
        parameterDefinitions.add(new ParameterDefinitionImpl(name, dataType));
        work.setParameterDefinitions(parameterDefinitions);
        return this;
    }
}

