/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.drools.core.util.IoUtils;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.util.WidMVELEvaluator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mvel2.CompileException;
import org.slf4j.LoggerFactory;

public class WidMVELEvaluatorTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testWidNoImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-noimports.wid")));
    }

    @Test
    public void testWidBackwardsCompatImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompat.wid")));
    }

    @Test
    public void testWidBackwardsCompatPkgImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompatpkgimport.wid")));
    }

    @Test
    public void testWidBackwardsCompatMixedAndMissingImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompatmixedandmissingimports.wid")));
    }

    @Test
    public void testWidCustomDataType() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-customdatatype.wid")));
    }

    @Test
    public void testWidCustomDataTypeNoImport() {
        try {
            this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-customdatatypenoimport.wid")));
        }
        catch (Throwable t) {
            Assertions.assertTrue((boolean)(t instanceof CompileException));
        }
    }

    protected String getResouceContent(String path) throws Exception {
        return new String(IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream(path)), "UTF-8");
    }

    protected String getResouce(String path) throws Exception {
        return this.getClass().getResource(path).getFile();
    }

    private void assertCorrectWids(Object wids) {
        Assertions.assertNotNull((Object)wids);
        List widsMap = (List)wids;
        Assertions.assertEquals((int)2, (int)widsMap.size());
        Map firstWid = (Map)widsMap.get(0);
        Assertions.assertNotNull((Object)firstWid);
        Assertions.assertEquals((Object)"MyFirstWorkItem", firstWid.get("name"));
        Map firstWidParams = (Map)firstWid.get("parameters");
        Assertions.assertNotNull((Object)firstWidParams);
        Assertions.assertEquals((int)6, (int)firstWidParams.size());
        Map firstWidParamValues = (Map)firstWid.get("parameterValues");
        Assertions.assertNotNull((Object)firstWidParamValues);
        Assertions.assertEquals((int)1, (int)firstWidParamValues.size());
        Map secondWid = (Map)widsMap.get(1);
        Assertions.assertNotNull((Object)secondWid);
        Assertions.assertEquals((Object)"MySecondWorkItem", secondWid.get("name"));
        Map secondWidParams = (Map)secondWid.get("parameters");
        Assertions.assertNotNull((Object)secondWidParams);
        Assertions.assertEquals((int)6, (int)secondWidParams.size());
        Map secondWidParamValues = (Map)secondWid.get("parameterValues");
        Assertions.assertNotNull((Object)secondWidParamValues);
        Assertions.assertEquals((int)1, (int)secondWidParamValues.size());
    }
}

